#pragma once

#include "script_action.h"

class TResubmitScriptAction: public IChatScriptAction {
private:
    using TBase = IChatScriptAction;

public:
    using TBase::TBase;

protected:
    virtual TMaybe<TString> AcceptMessage(const TNextActionInfo& actionInfo, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession) const override;
    virtual bool OnEnter(const ui32 chatRoomId, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession, TString& nextNodeId, const bool sendMessages = true, const TMaybe<ui64> lastMessageId = {}) const override;

private:
    static inline TFactory::TRegistrator<TResubmitScriptAction> Registrator{NChatRobot::EUserAction::Resubmit};
};
