#include "skip_action.h"

TMaybe<TString> TSkipScriptAction::AcceptMessage(const TNextActionInfo& actionInfo, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession) const {
    Y_UNUSED(tagsSession);
    Y_UNUSED(actionInfo);
    Y_UNUSED(stateContext);
    chatSession.SetErrorInfo("TSkipScriptAction::AcceptMessage", "user should not be able to send messages to this node");
    return Nothing();
}

bool TSkipScriptAction::OnEnter(const ui32 chatRoomId, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession, TString& nextNodeId, const bool sendMessages, const TMaybe<ui64> lastMessageId) const {
    if (!TBase::OnEnter(chatRoomId, stateContext, chatSession, tagsSession, nextNodeId, sendMessages, lastMessageId) || !TBase::OnExit(AddTag, stateContext, chatSession, tagsSession)) {
        return false;
    }
    auto nextScriptItem = GetContext()->GetChatRobot()->GetChatConfig().GetChatScript().GetNextScriptItem(GetCurrentScriptItem(), GetContext(), stateContext);
    if (nextScriptItem && nextScriptItem->GetId() && nextScriptItem->GetId() != GetCurrentScriptItem().GetId()) {
        nextNodeId = nextScriptItem->GetId();
        if (auto nextScriptActions = IChatScriptAction::Construct(GetContext(), *nextScriptItem, GetOperatorId())) {
            if (!nextScriptActions->OnEnter(chatRoomId, stateContext, chatSession, tagsSession, nextNodeId, sendMessages)) {
                return false;
            }
        } else {
            chatSession.SetErrorInfo("TSkipScriptAction::OnEnter", "cannot construct action " + ToString(nextScriptItem->GetActionType()));
            return false;
        }
    }
    return true;
}

bool TSkipScriptAction::OnExternalEvent(const ui32 chatRoomId, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession) const {
    auto nextScriptItem = GetContext()->GetChatRobot()->GetChatConfig().GetChatScript().GetNextScriptItem(GetCurrentScriptItem(), GetContext(), stateContext);
    if (nextScriptItem && nextScriptItem->GetId() && nextScriptItem->GetId() != GetCurrentScriptItem().GetId()) {
        TString nextNodeId = nextScriptItem->GetId();
        if (auto nextScriptActions = IChatScriptAction::Construct(GetContext(), *nextScriptItem, GetOperatorId())) {
            if (!nextScriptActions->OnEnter(chatRoomId, stateContext, chatSession, tagsSession, nextNodeId)) {
                return false;
            }
        } else {
            chatSession.SetErrorInfo("TSkipScriptAction::OnExternalEvent", "cannot construct action " + ToString(nextScriptItem->GetActionType()));
            return false;
        }
        if (!GetContext()->GetChatRobot()->UpdateChat(stateContext, GetContext()->GetUserId(), GetContext()->GetChatTopic(), nextNodeId, chatSession)) {
            return false;
        }
    }
    return true;
}
