#include "suggest.h"

IChatScriptAction::TFactory::TRegistrator<TSuggestScriptAction> TSuggestScriptAction::Registrator(TSuggestScriptAction::GetType());

bool TSuggestScriptAction::ShouldUseSuggest(const NDrive::NChat::TMessage& message) const {
    TMaybe<TChatRobotScriptItem> nextScriptItem = GetChatScript().GetScriptItemById(message.GetText());
    return !nextScriptItem.Defined() && GetCurrentScriptItem().GetUseClassifier() && GetCurrentScriptItem().GetNodeResolver();
}

TMaybe<TString> TSuggestScriptAction::AcceptMessage(const TNextActionInfo& actionInfo, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession) const {
    Y_UNUSED(tagsSession);
    NDrive::NChat::TMessage message = actionInfo.GetMessage();
    auto nodeIdMessage = message.GetText();
    TMaybe<TChatRobotScriptItem> nextScriptItem = GetChatScript().GetScriptItemById(nodeIdMessage);
    if (!nextScriptItem) {
        if (!AcceptRegularMessage(message, actionInfo.GetAttachments(), stateContext, chatSession)) {
            return Nothing();
        }
        return "";
    } else if (auto suggestText = GetCurrentScriptItem().GetNodeResolver()->GetSuggestText(nodeIdMessage)) {
        message.SetText(suggestText);
        if (!GetContext()->GetChatRobot()->SendArbitraryMessage(GetContext()->GetUserId(), GetContext()->GetChatTopic(), GetOperatorId(), message, chatSession, &stateContext)) {
            return Nothing();
        }
    }
    return nodeIdMessage;
}
