#pragma once

#include "script_action.h"

class TSuggestScriptAction: public IChatScriptAction {
private:
    using TBase = IChatScriptAction;
public:
    using TBase::TBase;

    static NChatRobot::EUserAction GetType() {
        return NChatRobot::EUserAction::Suggest;
    }

protected:
    virtual TMaybe<TString> AcceptMessage(const TNextActionInfo& actionInfo, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession) const override;
    virtual bool ShouldUseSuggest(const NDrive::NChat::TMessage& message) const override;

private:
    static TFactory::TRegistrator<TSuggestScriptAction> Registrator;
};
