#include "user_message.h"

#include <drive/backend/history_iterator/history_iterator.h>
#include <drive/library/cpp/trust/entity.h>

IChatScriptAction::TFactory::TRegistrator<TUserMessageScriptAction> TUserMessageScriptAction::Registrator(TUserMessageScriptAction::GetType());

TMaybe<TString> TUserMessageScriptAction::AcceptMessage(const TNextActionInfo& actionInfo, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession) const {
    AddTag = true;
    const NDrive::NChat::TMessage& message = actionInfo.GetMessage();
    NDrive::NChat::TMessage actualMessage = message;
    TString nextNodeId = "";
    if (message.GetType() == NDrive::NChat::TMessage::EMessageType::CreditCardBinding || message.GetType() == NDrive::NChat::TMessage::EMessageType::CreditCard) {
        auto card = FindCreditCardById(GetContext(), message.GetText());
        if (!card) {
            nextNodeId = GetCurrentScriptItem().GetFallbackNode();
            if (nextNodeId.empty()) {
                chatSession.SetErrorInfo("TUserMessageScriptAction::AcceptMessage", "cannot get user cards");
                return Nothing();
            }
        }
        if (!card->GetId().empty()) {
            actualMessage.SetText(card->GetAccount());
            GetCurrentScriptItem().AddSpecialValueToContext(stateContext, EContextDataType::CreditCardId, card->GetId());
            GetCurrentScriptItem().AddSpecialValueToContext(stateContext, EContextDataType::CreditCardMask, card->GetAccount());
        }
    } else if (message.GetType() == NDrive::NChat::TMessage::EMessageType::Order) {
        if (GetCurrentScriptItem().HasContextSettings()) {
            THistoryRidesContext ridesContext(GetContext()->GetServer());
            auto ydbTx = GetContext()->GetServer().GetDriveAPI()->BuildYdbTx<NSQL::ReadOnly>("user_message_script_action", &GetContext()->GetServer());
            if (ridesContext.InitializeSession(message.GetText(), tagsSession, ydbTx)) {
                if (auto ridingSession = ridesContext.GetSession(message.GetText())) {
                    GetCurrentScriptItem().AddSpecialValueToContext(stateContext, EContextDataType::SessionId, ridingSession->GetSessionId());
                    GetCurrentScriptItem().AddSpecialValueToContext(stateContext, EContextDataType::CarId, ridingSession->GetObjectId());
                } else {
                    nextNodeId = GetCurrentScriptItem().GetFallbackNode();
                    if (nextNodeId.empty()) {
                        chatSession.SetErrorInfo("TUserMessageScriptAction::AcceptMessage", "cannot get user ride");
                        return Nothing();
                    }
                }
            } else {
                return Nothing();
            }
        }
    }
    GetCurrentScriptItem().AddSpecialValueToContext(stateContext, EContextDataType::EnteredMessageType, ToString(actualMessage.GetType()));
    if (!AcceptRegularMessage(actualMessage, actionInfo.GetAttachments(), stateContext, chatSession)) {
        return Nothing();
    }
    return nextNodeId;
}
