LIBRARY()

OWNER(g:drive-backend)

PEERDIR(
    drive/backend/billing/interfaces
    drive/backend/chat
    drive/backend/chat_robots/channel
    drive/backend/chat_robots/configuration
    drive/backend/chat_robots/registration
    drive/backend/chat_robots/script_actions
    drive/backend/chat_robots/state
    drive/backend/chat_robots/suggest
    drive/backend/chat_robots/support
    drive/backend/common
    drive/backend/data
    drive/backend/data/complaint_tags
    drive/backend/database/drive
    drive/backend/database/entity
    drive/backend/database/history
    drive/backend/notifications/native_chat
    drive/backend/processor
    drive/backend/support_center/categorizer
    drive/backend/user_devices
    drive/backend/users
    drive/library/cpp/covid_pass
    drive/library/cpp/image_transformation
    drive/library/cpp/mds
    drive/library/cpp/searchserver/context
    drive/library/cpp/self_requester
    rtline/library/json/proto
    rtline/util/algorithm
)

SRCS(
    abstract.cpp
    media_resource.cpp
    media_storage.cpp
    robot_manager.cpp
    simple.cpp
    state_storage.cpp
    view_tracker.cpp
    GLOBAL condition.cpp
    GLOBAL hook_action.cpp
)

GENERATE_ENUM_SERIALIZATION_WITH_HEADER(condition.h)

GENERATE_ENUM_SERIALIZATION_WITH_HEADER(hook_action.h)

GENERATE_ENUM_SERIALIZATION_WITH_HEADER(ifaces.h)

GENERATE_ENUM_SERIALIZATION(error_type.h)

END()
