#pragma once

#include "orders_summary.h"
#include "mileage.h"

#include <rtline/util/types/accessor.h>
#include <rtline/util/types/range.h>

#include <drive/library/cpp/clickhouse/options.h>

#include <library/cpp/threading/future/future.h>

#include <util/system/mutex.h>
#include <util/thread/factory.h>

namespace NClickHouse {
    class TAsyncClient;
    class TClient;
    struct TAsyncClientOptions;
    struct TClientOptions;
}

namespace NDrive {
    class TClickHouseBackendClient {
    public:
        struct TOrdersSummaryQuery {
            R_FIELD(TVector<TString>, ObjectIds);
            R_FIELD(TRange<TInstant>, Timestamp);
            R_FIELD(TString, Tariff);
            R_FIELD(TString, AggregationType);
            R_READONLY(ui32, Finished, 1);
            R_READONLY(float, Mileage, 100000);
            R_OPTIONAL(ui64, Limit);
        };

        struct TMileageSummaryQuery {
            R_FIELD(TVector<TString>, ObjectIds);
            R_FIELD(TRange<TInstant>, Timestamp);
            R_FIELD(TString, AggregationType);
            R_OPTIONAL(ui64, Limit);
        };

        using TAllOrdersSummaryResult = TMap<TString, TAllOrdersSummary>;
        using TAllMileageSummaryResult = TMap<TString, TAllTMileageSummary>;

    public:
        TClickHouseBackendClient(const NClickHouse::TAsyncClientOptions& options);
        ~TClickHouseBackendClient();

        NThreading::TFuture<TAllOrdersSummaryResult> Get(const TOrdersSummaryQuery& query, TInstant deadline = TInstant::Zero()) const;
        NThreading::TFuture<TAllMileageSummaryResult> Get(const TMileageSummaryQuery& query, TInstant deadline = TInstant::Zero()) const;
    private:
        THolder<NClickHouse::TAsyncClient> Client;

    private:
        TString TimestampFieldBuilder(const TString& startOf) const;
    };
} // NDrive
