#pragma once

#include <drive/telematics/server/data/clickhouse/ctx.h>

namespace NDrive {
    struct TDayOrdersSummaryClickHouseCtx {
        TClickHouseColumn<NClickHouse::TColumnString,  0,  "object_id"> ObjectIdColumn;
        TClickHouseColumn<NClickHouse::TColumnUInt32,  1,  "timestamp"> TimestampColumn;
        TClickHouseColumn<NClickHouse::TColumnFloat64, 2,  "mileage_sum"> MileageColumn;
        TClickHouseColumn<NClickHouse::TColumnUInt64,  3,  "count"> CountColumn;
        TClickHouseColumn<NClickHouse::TColumnString,  4,  "offer_type"> OfferTypeColumn;
        TClickHouseColumn<NClickHouse::TColumnInt64,   5,  "duration"> DurationColumn;
        TClickHouseColumn<NClickHouse::TColumnString,  6,  "insurance_type"> InsuranceTypeColumn;
        TClickHouseColumn<NClickHouse::TColumnInt64,   7,  "entry_to_eco_zones_in_germany_sum"> EcoGermanyZonesColumn;
        TClickHouseColumn<NClickHouse::TColumnInt64,   8,  "snow_chains_sum"> SnowChainsColumn;
        TClickHouseColumn<NClickHouse::TColumnInt64,   9,  "gps_sum"> GpsColumn;
        TClickHouseColumn<NClickHouse::TColumnInt64,   10, "roof_rack_sum"> RoofRackColumn;
        TClickHouseColumn<NClickHouse::TColumnInt64,   11, "child_seat_sum"> ChildSeatColumn;
        TClickHouseColumn<NClickHouse::TColumnUInt64,  12, "total_payment_sum"> TotalPaymentColumn;
        TClickHouseColumn<NClickHouse::TColumnUInt64,  13, "riding_duration"> RidingDurationColumn;
        TClickHouseColumn<NClickHouse::TColumnString,  14, "currency"> CurrencyColumn;
        TClickHouseColumn<NClickHouse::TColumnInt64,   15, "start_time"> StartTimestampColumn;
        TClickHouseColumn<NClickHouse::TColumnInt64,   16, "finish_time"> FinishTimestampColumn;

        auto Columns() {
            return std::tie(
                ObjectIdColumn,
                TimestampColumn,
                MileageColumn,
                CountColumn,
                OfferTypeColumn,
                DurationColumn,
                InsuranceTypeColumn,
                EcoGermanyZonesColumn,
                SnowChainsColumn,
                GpsColumn,
                RoofRackColumn,
                ChildSeatColumn,
                TotalPaymentColumn,
                RidingDurationColumn,
                CurrencyColumn,
                StartTimestampColumn,
                FinishTimestampColumn
            );
        }
    };

    struct TMileageSummaryClickHouseCtx {
        TClickHouseColumn<NClickHouse::TColumnString,  0,  "object_id"> ObjectIdColumn;
        TClickHouseColumn<NClickHouse::TColumnUInt32,  1,  "timestamp"> TimestampColumn;
        TClickHouseColumn<NClickHouse::TColumnFloat64, 2,  "mileage"> MileageColumn;

        auto Columns() {
            return std::tie(
                ObjectIdColumn,
                TimestampColumn,
                MileageColumn
            );
        }
    };
} // NDrive
