#include "mileage.h"
#include "ctx.h"

void Extract(const NClickHouse::TBlock& block, NDrive::TMileageSummaryClickHouseRecords& records) {
    NDrive::TMileageSummaryClickHouseCtx ctx;
    NDrive::FillColumns(ctx, block);
    auto size = ctx.ObjectIdColumn->Size();
    Y_ENSURE_BT(size == ctx.TimestampColumn->Size());
    Y_ENSURE_BT(size == ctx.MileageColumn->Size());
    for (size_t i = 0; i < size; ++i) {
        NDrive::TMileageSummaryClickHouseRecord record;
        record.ObjectId = ctx.ObjectIdColumn->At(i);
        record.Timestamp = TInstant::Seconds(ctx.TimestampColumn->At(i));
        record.Mileage = ctx.MileageColumn->At(i);
        records.push_back(std::move(record));
    }
}
