#pragma once

#include <rtline/util/types/timestamp.h>

namespace NClickHouse {
    class TBlock;
    class TSimpleBlock;
}

namespace NDrive {
    struct TMileageSummary {
        TInstant Timestamp = TInstant::Zero();
        float Mileage = 0.0;
    };

    using TAllTMileageSummary = TVector<TMileageSummary>;

    struct TMileageSummaryClickHouseCtx;

    struct TMileageSummaryClickHouseRecord : TMileageSummary {
        TString ObjectId;
    };

    using TMileageSummaryClickHouseRecords = TVector<TMileageSummaryClickHouseRecord>;
}

void Extract(const NClickHouse::TBlock& block, NDrive::TMileageSummaryClickHouseRecords& records);
