#include "orders_summary.h"
#include "ctx.h"

namespace {
    const TString CompiledRidesClickHouseTable = "compiled_rides";
}

const TString& NDrive::GetCompiledRidesClickHouseTable() {
    return CompiledRidesClickHouseTable;
}

void Extract(const NClickHouse::TBlock& block, NDrive::TOrderSummaryClickHouseRecords& records) {
    NDrive::TDayOrdersSummaryClickHouseCtx ctx;
    NDrive::FillColumns(ctx, block);
    auto size = ctx.ObjectIdColumn->Size();
    Y_ENSURE_BT(size == ctx.TimestampColumn->Size());
    Y_ENSURE_BT(size == ctx.MileageColumn->Size());
    Y_ENSURE_BT(size == ctx.CountColumn->Size());
    Y_ENSURE_BT(size == ctx.OfferTypeColumn->Size());
    Y_ENSURE_BT(size == ctx.DurationColumn->Size());
    Y_ENSURE_BT(size == ctx.InsuranceTypeColumn->Size());
    Y_ENSURE_BT(size == ctx.EcoGermanyZonesColumn->Size());
    Y_ENSURE_BT(size == ctx.SnowChainsColumn->Size());
    Y_ENSURE_BT(size == ctx.GpsColumn->Size());
    Y_ENSURE_BT(size == ctx.RoofRackColumn->Size());
    Y_ENSURE_BT(size == ctx.ChildSeatColumn->Size());
    Y_ENSURE_BT(size == ctx.TotalPaymentColumn->Size());
    Y_ENSURE_BT(size == ctx.RidingDurationColumn->Size());
    Y_ENSURE_BT(size == ctx.CurrencyColumn->Size());
    Y_ENSURE_BT(size == ctx.StartTimestampColumn->Size());
    Y_ENSURE_BT(size == ctx.FinishTimestampColumn->Size());
    for (size_t i = 0; i < size; ++i) {
        NDrive::TOrderSummaryClickHouseRecord record;
        record.ObjectId = ctx.ObjectIdColumn->At(i);
        record.Mileage = ctx.MileageColumn->At(i);
        record.Count = ctx.CountColumn->At(i);
        record.OfferType = ctx.OfferTypeColumn->At(i);
        record.Duration = ctx.DurationColumn->At(i);
        record.InsuranceType = ctx.InsuranceTypeColumn->At(i);
        record.AddonSalesCount.EcoGermanyZones = ctx.EcoGermanyZonesColumn->At(i);
        record.AddonSalesCount.SnowChains = ctx.SnowChainsColumn->At(i);
        record.AddonSalesCount.Gps = ctx.GpsColumn->At(i);
        record.Timestamp = TInstant::Seconds(ctx.TimestampColumn->At(i));
        record.AddonSalesCount.RoofRack = ctx.RoofRackColumn->At(i);
        record.AddonSalesCount.ChildSeat = ctx.ChildSeatColumn->At(i);
        record.TotalPayment = ctx.TotalPaymentColumn->At(i);
        record.RidingDuration = ctx.RidingDurationColumn->At(i);
        record.Currency = ctx.CurrencyColumn->At(i);
        record.StartLongOrderTimestamp = static_cast<ui64>(ctx.StartTimestampColumn->At(i));
        record.FinishLongOrderTimestamp = static_cast<ui64>(ctx.FinishTimestampColumn->At(i));
        records.push_back(std::move(record));
    }
}
