#pragma once

#include <rtline/util/types/timestamp.h>

namespace NClickHouse {
    class TBlock;
    class TSimpleBlock;
}

namespace NDrive {
    struct TAddonsSalesCount {
        i64 EcoGermanyZones = 0;
        i64 SnowChains = 0;
        i64 Gps = 0;
        i64 RoofRack = 0;
        i64 ChildSeat = 0;

        TAddonsSalesCount& operator+=(const TAddonsSalesCount& value) {
            this->EcoGermanyZones += value.EcoGermanyZones;
            this->SnowChains += value.SnowChains;
            this->Gps += value.Gps;
            this->RoofRack += value.RoofRack;
            this->ChildSeat += value.ChildSeat;
            return *this;
        }

       TAddonsSalesCount() = default;
    };

    struct TOrdersSumaryBase {
        float Mileage = 0.0;
        ui64 Count = 0;
        i64 Duration = 0;
        TAddonsSalesCount AddonSalesCount;
        ui64 TotalPayment = 0;
        ui64 RidingDuration = 0;

        TOrdersSumaryBase() = default;

        TOrdersSumaryBase& operator+=(const TOrdersSumaryBase& value) {
            this->Mileage += value.Mileage;
            this->Count += value.Count;
            this->Duration += value.Duration;
            this->AddonSalesCount += value.AddonSalesCount;
            this->TotalPayment += value.TotalPayment;
            this->RidingDuration += value.RidingDuration;
            return *this;
        }
    };

    struct TOrdersSumary : public TOrdersSumaryBase {
        TInstant Timestamp = TInstant::Zero();
        TString InsuranceType;
        TString OfferType;
        TString Currency;
        ui64 StartLongOrderTimestamp = 0;
        ui64 FinishLongOrderTimestamp = 0;

        TOrdersSumary() = default;
    };

    using TAllOrdersSummary = TVector<TOrdersSumary>;

    struct TDayOrdersSummaryClickHouseCtx;

    struct TOrderSummaryClickHouseRecord : TOrdersSumary {
        TString ObjectId;
        TOrderSummaryClickHouseRecord() = default;
    };

    using TOrderSummaryClickHouseRecords = TVector<TOrderSummaryClickHouseRecord>;

    const TString& GetCompiledRidesClickHouseTable();
}

void Extract(const NClickHouse::TBlock& block, NDrive::TOrderSummaryClickHouseRecords& records);
