#pragma once

#include <drive/backend/abstract/base.h>

#include <drive/library/cpp/scheme/scheme.h>

#include <rtline/util/json_processing.h>

#include <util/string/split.h>

class TAttributedEntityDefaultFieldNames {
public:
    static const TString GetAttributesFieldName() {
        return "groupping_attributes";
    }
    static const TString GetObjectFieldName() {
        return "attributed_entity";
    }
};

template <class TFieldNames>
class TAttributedEntity {
    R_FIELD(TSet<TString>, GrouppingTags);
public:
    bool DeserializeAttributes(const NJson::TJsonValue& jsonSettings) {
        return TJsonProcessor::ReadContainer(jsonSettings, TFieldNames::GetAttributesFieldName(), GrouppingTags);
    }

    static void FillAttributesScheme(const IServerBase& server, const TString& settingsKey, NDrive::TScheme& result) {
        const TString attributesStr = server.GetSettings().GetValueDef<TString>("administration.attributes." + settingsKey, "");
        const TVector<TString> variants = StringSplitter(attributesStr).SplitBySet(", ").SkipEmpty().ToList<TString>();
        if (variants.size()) {
            result.Add<TFSVariants>(TFieldNames::GetAttributesFieldName(), "Аттрибуты для группировки").SetVariants(variants).SetMultiSelect(true);
        } else {
            result.Add<TFSString>(TFieldNames::GetAttributesFieldName(), "Аттрибуты для группировки");
        }
    }

    void SerializeAttributes(NJson::TJsonValue& result) const {
        TJsonProcessor::WriteContainerArray(result, TFieldNames::GetAttributesFieldName(), GrouppingTags);
    }

    void InsertObjectToJson(NJson::TJsonValue& result) const {
        result.InsertValue(TFieldNames::GetObjectFieldName(), SerializeObjectToJson());
    }

    NJson::TJsonValue SerializeObjectToJson() const {
        NJson::TJsonValue result = NJson::JSON_MAP;
        TJsonProcessor::WriteContainerArray(result, TFieldNames::GetAttributesFieldName(), GrouppingTags);
        return result;
    }

    bool DeserializeObjectFromJson(const NJson::TJsonValue& jsonInfo) {
        if (jsonInfo.Has(TFieldNames::GetObjectFieldName())) {
            return DeserializeAttributes(jsonInfo[TFieldNames::GetObjectFieldName()]);
        } else {
            return true;
        }
    }

    static NDrive::TScheme GetScheme(const IServerBase& server, const TString& settingsKey) {
        NDrive::TScheme result;
        FillAttributesScheme(server, settingsKey, result);
        return result;
    }

    static void InsertScheme(const IServerBase& server, const TString& settingsKey, NDrive::TScheme& scheme) {
        scheme.Add<TFSStructure>(TFieldNames::GetObjectFieldName(), "атрибуты объекта").SetStructure(GetScheme(server, settingsKey));
    }
};
