#pragma once

#include <drive/backend/abstract/base.h>

#include <drive/library/cpp/scheme/scheme.h>

#include <library/cpp/regex/pcre/regexp.h>


class THostFilter {
private:
    R_READONLY(TString, HostPattern);
    R_READONLY(TString, FQDNHostPattern);
    R_READONLY(TString, CType);
    R_READONLY(TRegExMatch, HostPatternRegex);
    R_READONLY(TRegExMatch, FQDNHostPatternRegex);

public:
    explicit operator bool() const {
        return CType || FQDNHostPattern || HostPattern;
    }

    THostFilter& SetHostPattern(const TString& hostPattern);
    THostFilter& SetFQDNHostPattern(const TString& hostPattern);

    bool CheckHost(const IServerBase& server) const;

    NJson::TJsonValue SerializeToJson() const;
    bool DeserializeFromJson(const NJson::TJsonValue& jsonInfo);

    NDrive::TScheme GetScheme(const IServerBase& server, const TString& defaults) const;
};
