#pragma once

#include <util/string/builder.h>
#include <util/string/cast.h>
#include <util/string/printf.h>

namespace NDrive {
    class TLocalization {
    public:
        static TString BlackboxProblems() {
            return "Проблемы при авторизации";
        }

        //client
        static TString IncorrectUserDestination() {
            return "Некорректная точка назначения";
        }

        //client
        static TString Overrunning() {
            return "Перепробег";
        }

        //client
        static TString BuildScannerMessage(const TString& originalMessage) {
            return "РАДАР: " + originalMessage;
        }

        //cliend
        static TString IncorrectHeadId() {
            return "Неправильный идентификатор ГУ";
        }

        //client
        static TString ScannerExpired() {
            return "Радар выключен.";
        }

        //client
        static TString ScannerOrderReady(const TString& model, const TString& details) {
            return "Радар забронировал " + model + ". " + details;;
        }

        //client
        static TString DriveAppName() {
            return "Яндекс.Драйв";
        }

        //client
        static TString ScannerCarIsFound(const TString& model, const TString& details) {
            return "Радар нашел " + model + ". " + details;
        }

        //client
        static TString TooOldApplication() {
            return "У вас старая версия приложения. Пожалуйста, обновите.";
        }

        static TString NoPermissionsRemoveTag() {
            return "Нет прав для удаления тега.";
        }

        static TString TagUsingByAnother() {
            return "Тег используется другим пользователем.";
        }

        //client
        static TString CannotBuildOffer() {
            return "Не получается сформулировать предложение по аренде.";
        }

        static TString NoPermissionsForPerform() {
            return "Нет прав для взятия в работу данного тега. Проверьте, что он все еще свободен.";
        }

        //client
        static TString IncorrectFilter() {
            return "Неправильно задан фильтр для поиска машин.";
        }

        //client
        static TString IncorrectCarPosition() {
            return "К сожалению, завершить аренду здесь не получится.";
        }

        //client
        static TString IncorrectCarSignal() {
            return "Вероятно, здесь не ловит GPS. Переставьте машину, пожалуйста.";
        }

        static TString LockedResourcesLimitEnriched() {
            return "Достигнуто ограничение по количеству одновременно используемых ресурсов";
        }

        static TString IncorrectTagObjectType() {
            return "Некорректный тег для данного типа объектов";
        }

        //client
        static TString ResourceHasMajorProblems() {
            return "Машина имеет приоритетные проблемы для решения";
        }

        //client
        static TString IncorrectCarStatus() {
            return "Неправильный статус машины. Возможно, уже занята";
        }

        //client
        static TString BonusBillingHeader() {
            return "Сняты бонусы";
        }

        //client
        static TString CardBillingHeader() {
            return "Карта";
        }

        //client
        static TString CashbackBillingHeader() {
            return "Ваши баллы за поездку";
        }

        //client
        static TString CashbackBillingNonPlusDetails() {
            return "Активируйте баллы и подписку";
        }

        //client
        static TString BonusBillingDetails() {
            return "Сняты бонусы в счет оплаты полученных услуг";
        }

        //client
        static TString MoneyBillingHeader() {
            return "Сняты деньги";
        }

        //client
        static TString MoneyBillingDetails() {
            return "Сняты деньги с карты в счет оплаты полученных услуг";
        }

        static TString InProgressBillingHeader() {
            return "В обработке";
        }

        static TString InProgressBillingDetails() {
            return "Сумма находится в обработке и ожидает решения со стороны банка";
        }

        //client
        static TString DiscountBillSection() {
            return "Скидка";
        }

        //client
        static TString DiscountsBillSection() {
            return "Скидки";
        }

        //client
        static TString BillingBillSection() {
            return "Способ оплаты";
        }

        //client
        static TString CashbackBillSection() {
            return "Кэшбэк";
        }

        //client
        static TString CashbackBillNonPlusSection() {
            return "Кэшбэк на Яндекс.Плюс";
        }

        //client
        static TString TotalBillHeader() {
            return "Итого";
        }

        //client
        static TString BillPlus() {
            return "Оплачено плюсом";
        }

        //client
        static TString WarningTitle() {
            return "Внимание";
        }

        //client
        static TString DeclineOffer() {
            return "Отклонить";
        }

        //client
        static TString AcceptOffer() {
            return "Принять";
        }

        //client
        static TString Discount() {
            return "Скидка";
        }

        static TString IDMRequired() {
            return "Пожалуйста, используйте IDM для управления этой ролью";
        }

        static TString IncorrectRequest() {
            return "Проблема формирования или неподходящего использования запроса.";
        }

        //client
        static TString ServerProblems() {
            return "Возможно, день такой. Попробуйте ещё раз.";
        }

        static TString IncorrectUserOffer() {
            return "Предложение было сформировано другим пользователем.";
        }

        //client
        static TString PhoneNotVerified() {
            return "Телефон не подтвержден";
        }

        //client
        static TString EmailNotVerified() {
            return "Адрес электронной почты не подтвержден";
        }

        //client
        static TString OfferProblems() {
            return "Не получается восстановить предложение.";
        }

        //client
        static TString NoCardsProblems() {
            return "Нет привязанных банковских карт.";
        }

        //client
        static TString OfferExpired() {
            return "Срок предложения истек.";
        }

        //client
        static TString OfferInconsistency() {
            return "Данные предложения не соответствуют текущим данным пользователя.";
        }

        //client
        static TString InconsistencyUser() {
            return "Нарушена консистентность данных в запросах пользователя.";
        }

        static TString NoOptionalRole() {
            return "Роль не является опциональной.";
        }

        //client
        static TString NoPermissions() {
            return "Нет прав для выполнения данного действия";
        }

        //client
        static TString NoDeviceId() {
            return "Нет заголовка, определяющего устройство";
        }

        //client
            static TString CannotRegisterFirstDevice() {
            return "Не можем добавить первое устройство";
        }

        //client
        static TString DisabledDeviceId() {
            return "Заблокированный DeviceId для данного пользователя";
        }

        //client
        static TString NewDeviceId() {
            return "Некорректный DeviceId для данного пользователя";
        }

        //client
        static TString PaymentRequired() {
            return "Погасите долг.";
        }

        //client
        static TString RequiredDepositIsNotHeld() {
            return "Резервируем залог";
        }

        //client
        static TString CarInUsing() {
            return "Машина занята.";
        }

        //client
        static TString IncorrectCar() {
            return "Проблемы с машиной. лучше попробовать еще раз.";
        }

        static TString NotAvailableCommandForPerformedTasks() {
            return "Не допустимая команда для данной машины. Проверьте, что необходимые задачи для данной машины взяты в исполнение.";
        }

        static TString IncorrectCarsForUser() {
            return "Не можем определить к какой машине относится команда.";
        }

        //client
        static TString UserHaveRentedCar() {
            return "У Вас уже есть забронированная машина";
        }

        static TString NoLockedCars() {
            return "Для данного действия машина должна быть взята в аренду.";
        }

        //client
        static TString CarCooldown() {
            return "Hold on, I am just a wee bit confused right now";
        }

        //client
        static TString DuplicatePromoCode() {
            return "Промокод уже был использован";
        }

        //client
        static TString IncorrectUserReply() {
            return "Некорректная реакция пользователя";
        }

        //client
        static TString UserShouldBeBlocked() {
            return "Заблокированный пользователь не может выполнить данное действие";
        }

        //client
        static TString RequestForUser() {
            return "Требуется ответ пользователя";
        }

        //client
        static TString CarIsBusy() {
            return "Машина уже занята.";
        }

        //client
        static TString IncorrectCarTags() {
            return "Внутренняя ошибка - машина не подготовлена к работе.";
        }

        //client
        static TString TransmissionName() {
            return "Коробка";
        }

        //client
        static TString DriveUnitName() {
            return "Привод";
        }

        //client
        static TString SeatsNumberName() {
            return "Мест";
        }

        //client
        static TString FuelTankVolumeName() {
            return "Бак";
        }

        //client
        static TString AccelerationTimeName() {
            return "Разгон";
        }

        //client
        static TString PowerName() {
            return "Мощность";
        }

        //client
        static TString TryAnotherUser() {
            return "Найдите другого";
        }

        //client
        static TString TryAnotherCar() {
            return "Попробуйте передать ему другую";
        }

        //client
        static TString SameUserDelegation() {
            return "Вы пытаетесь передать машину самому себе";
        }

        //client
        static TString DelegationToBlockedUser() {
            return "Этот пользователь заблокирован в Драйве";
        }

        //client
        static TString DelegationUserNotCompletedRegistration() {
            return "Этот пользователь еще не завершил регистрацию в Драйве";
        }

        //client
        static TString DelegationUserNotPresent() {
            return "Такой номер не зарегистрирован в Драйве";
        }

        //client
        static TString DelegationUserCantUseCar() {
            return "У этого пользователя нет доступа к такой машине";
        }

        //client
        static TString DelegationPossible() {
            return "Все ок, пользователь получит уведомление";
        }

        //client
        static TString DelegationUserDisabledP2P() {
            return "Этот пользователь запретил передавать ему руль";
        }

        //client
        static TString PowerValue(const ui32 power) {
            return ToString(power) + " л.с.";
        }

        //client
        static TString AccelerationValue(const float acc) {
            TString result = Sprintf("%0.1f с", acc);
            /*
                Replace . with ,
            */
           size_t dotPosition = result.find('.');
           if (dotPosition != TString::npos) {
               result[dotPosition] = ',';
           }
           return result;
        }

        //client
        static TString SeatsNumberValue(const ui32 number) {
            return "1+" + ToString(number - 1);
        }

        //client
        static TString FuelTankVolumeValue(const ui32 volume) {
            return ToString(volume) + " л";
        }

        //client
        static TString FormalTariffName(TStringBuf name) {
            return TStringBuilder() << "Тариф «" << name << "»";
        }

        //client
        static TString MileageReceiptElementTitle() {
            return "Пробег";
        }

        //client
        static TString OverrunReceiptElementTitle() {
            return "Перерасход км";
        }

        //client
        static TString OvertimeReceiptElementTitle() {
            return "Перерасход минут";
        }

        //client
        static TString MinutesReceiptElementTitle() {
            return "Время";
        }

        //client
        static TString DistanceReceiptElementTitle() {
            return "Расстояние";
        }

        //client
        static TString DeviceAlreadyAttached() {
            return "Устройство уже прикреплено к этому авто.";
        }

        //client
        static TString DeviceAttachedToDifferentCar() {
            return "Устройство прикреплено к другому авто.";
        }

        //client
        static TString EmailExists() {
            return "Пользователь с таким адресом электронной почты уже зарегистрирован";
        }

        //client
        static TString EmailInvalid() {
            return "Некорректный адрес электронной почты";
        }

        //client
        static TString UnableToUpsertDevice() {
            return "Невозможно опознать тип устройства, или сим-карта внутри устройства уже используется.";
        }

        static TString ResourceCantBeDeleted() {
            return "Невозможно удалить используемый ресурс.";
        }

        static TString BonusRubles(const ui32 amount) {
            if (amount % 10 == 1 && (amount % 100) != 11) {
                return "бонусный рубль";
            } else if (amount % 10 > 1 && amount % 10 < 5 && (amount % 100) / 10 != 1) {
                return "бонусных рубля";
            } else {
                return "бонусных рублей";
            }
        }
    };
}
