#pragma once

#include <library/cpp/mediator/messenger.h>

#include <rtline/util/types/accessor.h>
#include <rtline/util/types/messages_collector.h>

#include <util/generic/set.h>
#include <util/generic/string.h>

class TRegularDBServiceMessage: public IMessage {
public:
    R_FIELD(TMessagesCollector, Report);
    R_FIELD(TString, UserId);

public:
    TRegularDBServiceMessage(const TString& userId)
        : UserId(userId)
    {
    }

    bool IsEmpty() const {
        return !Report.HasMessages();
    }

    TString GetStringReport() const {
        return Report.GetStringReport();
    }
};

namespace NDrive {
    class TCacheRefreshMessage : public IMessage {
        R_FIELD(TSet<TString>, Components);

    public:
        TCacheRefreshMessage() = default;
        TCacheRefreshMessage(const TSet<TString>& entities)
            : Components(entities) {}
        TCacheRefreshMessage(const TString& componentId) {
            Components.emplace(componentId);
        }
    };
}
