#include "compiled.h"

#include <rtline/util/algorithm/type_traits.h>

TCompiledAdditionalService::TDecoder::TDecoder(const TMap<TString, ui32>& decoderBase) {
    Id = GetFieldDecodeIndex("id", decoderBase);
    SessionId = GetFieldDecodeIndex("session_id", decoderBase);
    StartInstant = GetFieldDecodeIndex("start", decoderBase);
    FinishInstant = GetFieldDecodeIndex("finish", decoderBase);
}

bool TCompiledAdditionalService::DeserializeWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* /*hContext*/) {
    READ_DECODER_VALUE(decoder, values, Id);
    READ_DECODER_VALUE(decoder, values, SessionId);
    READ_DECODER_VALUE_INSTANT(decoder, values, StartInstant);
    READ_DECODER_VALUE_INSTANT(decoder, values, FinishInstant);
    return true;
}

NStorage::TTableRecord TCompiledAdditionalService::SerializeToTableRecord() const {
    NStorage::TTableRecord result;
    result.Set("id", SessionId);
    result.Set("session_id", SessionId);
    result.Set("start", StartInstant.Seconds());
    result.Set("finish", FinishInstant.Seconds());
    return result;
}

NJson::TJsonValue TCompiledAdditionalService::GetReport() const {
    NJson::TJsonValue result;
    result.InsertValue("id", Id);
    result.InsertValue("session_id", SessionId);
    result.InsertValue("start", StartInstant.Seconds());
    result.InsertValue("finish", FinishInstant.Seconds());
    return result;
}

template struct TExpectedSizeOf<TCompiledAdditionalService, 32>;
