#pragma once

#include <rtline/util/types/timestamp.h>
#include <util/generic/string.h>
#include <rtline/util/types/accessor.h>
#include <rtline/library/storage/structured.h>

class IHistoryContext;

class TCompiledAdditionalService {
    R_FIELD(TString, Id);
    R_FIELD(TString, SessionId);
    R_FIELD(TTimestamp, StartInstant);
    R_FIELD(TTimestamp, FinishInstant);

public:
    virtual ~TCompiledAdditionalService() = default;

    inline bool operator<(const TCompiledAdditionalService& other) const {
        return std::tie(FinishInstant, Id) < std::tie(other.FinishInstant, other.Id);
    }

    TDuration GetDuration() const {
        return FinishInstant - StartInstant;
    }

    class TDecoder: public TBaseDecoder {
        R_FIELD(i32, Id, -1);
        R_FIELD(i32, SessionId, -1);
        R_FIELD(i32, StartInstant, -1);
        R_FIELD(i32, FinishInstant, -1);

    public:
        TDecoder() = default;
        TDecoder(const TMap<TString, ui32>& decoderBase);

        static TString GetFieldsForRequest() {
            return "id, session_id, start, finish";
        }
    };

    bool DeserializeWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* /*hContext*/);

protected:
    NStorage::TTableRecord SerializeToTableRecord() const;
    NJson::TJsonValue GetReport() const;
};
