#pragma once

#include <drive/backend/users/user_documents.h>

#include <util/datetime/base.h>
#include <util/generic/maybe.h>

namespace NPhotoRecognizerUtils {
    TMaybe<TString> ExtractStr(const TString& recognized);
    TMaybe<TString> ExtractDateStrIfValid(const TString& recognized);
    ui32 DaysInMonth(const ui32 year, const ui32 month);
    TMaybe<TInstant> ExtractDateIfValid(const TString& recognized);
    TMaybe<TString> ExtractYearStrIfValid(const TString& recognized);
    TRecognitionConfidenceData GetEmptyLicenseConfidencesFront();
    TRecognitionConfidenceData GetEmptyLicenseConfidencesBack();
    TRecognitionConfidenceData GetEmptyPassportConfidences();
}
