#!/usr/bin/env bash

FILENAME=$(basename $1)

if [ "$FILENAME" = "testing.conf" ]; then
    TYPE="YA_DRIVE_BACKEND_CONFIG_TESTING"
elif [ "$FILENAME" = "service.conf" ]; then
    TYPE="YA_DRIVE_BACKEND_CONFIG_SERVICE"
elif [ "$FILENAME" = "robot.conf" ]; then
    TYPE="YA_DRIVE_BACKEND_CONFIG_ROBOT"
elif [ "$FILENAME" = "qa.conf" ]; then
    TYPE="YA_DRIVE_BACKEND_CONFIG_QA"
elif [ "$FILENAME" = "production.conf" ]; then
    TYPE="YA_DRIVE_BACKEND_CONFIG_PRODUCTION"
elif [ "$FILENAME" = "prestable.conf" ]; then
    TYPE="YA_DRIVE_BACKEND_CONFIG_PRESTABLE"
elif [ "$FILENAME" = "chat.conf" ]; then
    TYPE="YA_DRIVE_BACKEND_CONFIG_CHAT"
elif [ "$FILENAME" = "admin.conf" ]; then
    TYPE="YA_DRIVE_BACKEND_CONFIG_ADMIN"
elif [ "$FILENAME" = "drivematics.conf.xml" ]; then
    TYPE="YA_DRIVE_BACKEND_CONFIG_LEASING"
elif [ "$FILENAME" = "drivematics_prestable.conf.xml" ]; then
    TYPE="YA_DRIVE_BACKEND_CONFIG_LEASING_PRESTABLE"
elif [ "$FILENAME" = "drivematics_testing.conf.xml" ]; then
    TYPE="YA_DRIVE_BACKEND_CONFIG_LEASING_TESTING"
elif [ "$FILENAME" = "environment.lua" ]; then
    TYPE="YA_DRIVE_BACKEND_ENVIRONMENT"
else
    echo "cannot determine resource type for $FILENAME"
    exit -1
fi

echo "uploading $1 with type $TYPE"
ya upload --backup --ttl 42 --type $TYPE $1
