#include "aggression.h"

#include <drive/library/cpp/raw_text/datetime.h>

namespace NDrive {

    TAggressionFetchContext::TAggressionFetchContext(
        const NDrive::IServer* server,
        const TAggressionEntry& entry
    )
        : TBase(server, entry)
    {
    }

    const TString IAggressionContextFetcher::TypeNamePrefix = "aggression.";

    TString TTrialMileageAggressionFetcher::GetTypeName() {
        return TypeNamePrefix + "trial_mileage";
    }

    bool TTrialMileageAggressionFetcher::Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const {
        if (!context.GetEntry().HasTrialTag()) {
            errors.AddMessage(__LOCATION__, "Context does not have trial tag");
            return false;
        }
        result = Sprintf("%d", int(context.GetEntry().GetTrialTagRef().GetValue()));
        return true;
    }

    TTrialMileageAggressionFetcher::TRegistrator TTrialMileageAggressionFetcher::Registrator;

    TString TBlockEndDateAggressionFetcher::GetTypeName() {
        return TypeNamePrefix + "block_end_date";
    }

    bool TBlockEndDateAggressionFetcher::Fetch(
        const TContextType& context,
        TString& result,
        TMessagesCollector& errors
    ) const {
        if (!context.GetEntry().HasBlockTag()) {
            errors.AddMessage(__LOCATION__, "Context does not have block tag");
            return false;
        }
        const ILocalization* localization = context.GetServer().GetLocalization();
        result = localization->FormatMonthDay(
            ELocalization::Rus,
            context.GetEntry().GetBlockTagRef().GetSLAInstant() + TDuration::Hours(3)
        );
        return true;
    }

    TBlockEndDateAggressionFetcher::TRegistrator TBlockEndDateAggressionFetcher::Registrator;
}
