#pragma once

#include "base.h"

#include <drive/backend/data/scoring/scoring.h>
#include <drive/backend/data/user_tags.h>
#include <drive/library/cpp/context_fetcher/fetcher.h>

namespace NDrive {

    class TAggressionEntry {
    private:
        R_OPTIONAL(TScoringUserTag, UserTag);
        R_OPTIONAL(TScoringUserTag, TrialTag);
        R_OPTIONAL(TUserProblemTag, BlockTag);
    };

    class TAggressionFetchContext: public TFetchContext<TAggressionEntry, TEntryConstRefHolder<TAggressionEntry>> {
        using TBase = TFetchContext<TAggressionEntry, TEntryConstRefHolder<TAggressionEntry>>;

    public:
        TAggressionFetchContext(const NDrive::IServer* server, const TAggressionEntry& entry);
    };

    class IAggressionContextFetcher: public IContextFetcher<IAggressionContextFetcher, TAggressionFetchContext> {
        using TBase = IContextFetcher<IAggressionContextFetcher, TAggressionFetchContext>;

    public:
        using TBase::TBase;

        static const TString TypeNamePrefix;
    };

    class TTrialMileageAggressionFetcher: public IAggressionContextFetcher {
        using TBase = IAggressionContextFetcher;

    public:
        using TBase::TBase;

        static TString GetTypeName();

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

    private:
        using TRegistrator = TFactory::TRegistrator<TTrialMileageAggressionFetcher>;
        static TRegistrator Registrator;
    };

    class TBlockEndDateAggressionFetcher: public IAggressionContextFetcher {
        using TBase = IAggressionContextFetcher;

    public:
        using TBase::TBase;

        static TString GetTypeName();

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

    private:
        using TRegistrator = TFactory::TRegistrator<TBlockEndDateAggressionFetcher>;
        static TRegistrator Registrator;
    };

}
