#pragma once

#include <drive/library/cpp/context_fetcher/context.h>

// The intent of the fetchers is the next:
// - to provide a generic base for fetchers and a unique context processor to substitute arbitraty placeholders
// - to place fethers near by related data (user related fetcher close to TDriveUserData and so on)
//     and register them globally
// - to re-use code to fetch user data and specific user data traits
// - to lookup data of the user performing smth or user related to a fine through base user fetchers
//     simply invoking one fether from another one
// NB. FACTORY\_OBJECT\_NAME macro could be used

namespace NDrive {
    class INotifyResultProvider;
    class IServer;
}

template <typename TEntry, typename TEntryHolder = TEntryAtomicSharedPtrHolder<TEntry>>
class TFetchContext: public TPlainFetchContext<TEntry, TEntryHolder> {
    using TBase = TPlainFetchContext<TEntry, TEntryHolder>;

public:
    using TEntryType = typename TBase::TEntryType;
    using TDynamicContext = typename TBase::TDynamicContext;

    using TBase::GetEntry;

    using TBase::GetOptions;
    using TBase::SetOptions;
    using TBase::MutableOptions;

    using TBase::GetDynamicContext;
    using TBase::SetDynamicContext;
    using TBase::MutableDynamicContext;

    using INotifyResultProviderPtr = TAtomicSharedPtr<NDrive::INotifyResultProvider>;

    TFetchContext(const NDrive::IServer* server, const TEntryType& entry, const TDynamicContext& dynamicContext = {}, INotifyResultProviderPtr notifyResultProvider = nullptr)
        : TBase(entry, dynamicContext)
        , Server(server)
        , NotifyResultProvider(notifyResultProvider)
    {
    }

    TFetchContext(const NDrive::IServer& server, const TEntryType& entry, const TDynamicContext& dynamicContext = {}, INotifyResultProviderPtr notifyResultProvider = nullptr)
        : TFetchContext(&server, entry, dynamicContext, notifyResultProvider)
    {
    }

    const NDrive::IServer& GetServer() const {
        return *Server;
    }

protected:
    const NDrive::IServer* Server;

    R_READONLY(INotifyResultProviderPtr, NotifyResultProvider);
};
