#pragma once

#include "base.h"

#include <drive/backend/tags/tags.h>

#include <drive/library/cpp/context_fetcher/fetcher.h>

#include <rtline/util/types/messages_collector.h>

class TDriveCarInfo;
class TDriveUserData;
class THistoryDeviceSnapshot;

class TCarTagHistoryEventFetchContext: public TFetchContext<TCarTagHistoryEvent, TEntryConstRefHolder<TCarTagHistoryEvent>> {
    using TBase = TFetchContext<TCarTagHistoryEvent, TEntryConstRefHolder<TCarTagHistoryEvent>>;

public:
    TCarTagHistoryEventFetchContext(const NDrive::IServer* server, const TCarTagHistoryEvent& event, TString placeholderStart = "{", TString placeholderEnd = "}");

private:
    R_FIELD(TString, TimezoneName, "Europe/Moscow");
};

class ICarTagHistoryEventContextFetcher: public IContextFetcher<ICarTagHistoryEventContextFetcher, TCarTagHistoryEventFetchContext> {
    using TBase = IContextFetcher<ICarTagHistoryEventContextFetcher, TCarTagHistoryEventFetchContext>;

public:
    using TBase::TBase;

public:
    static const TString SettingPrefix;
    static const TString LocalizationPrefix;
};

class IEventContextFetcher: public ICarTagHistoryEventContextFetcher {
    using TBase = ICarTagHistoryEventContextFetcher;

protected:
    using TBase::TBase;

    bool FetchPerformer(const TContextType& context, TDriveUserData& userData) const;

    static const TString TypeNamePrefix;
};

class TEventInstantContextFetcher: public IEventContextFetcher {
    using TBase = IEventContextFetcher;

public:
    using TBase::TBase;

    virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

    static TString GetTypeName();

private:
    using TRegistrator = TFactory::TRegistrator<TEventInstantContextFetcher>;
    static TRegistrator Registrator;
};

class TEventDateContextFetcher: public IEventContextFetcher {
    using TBase = IEventContextFetcher;

public:
    using TBase::TBase;

    virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

    static TString GetTypeName();

private:
    using TRegistrator = TFactory::TRegistrator<TEventDateContextFetcher>;
    static TRegistrator Registrator;
};

class TEventUserLoginContextFetcher: public IEventContextFetcher {
    using TBase = IEventContextFetcher;

public:
    using TBase::TBase;

    virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

    static TString GetTypeName();

private:
    using TRegistrator = TFactory::TRegistrator<TEventUserLoginContextFetcher>;
    static TRegistrator Registrator;
};

class ITagContextFetcher: public ICarTagHistoryEventContextFetcher {
    using TBase = ICarTagHistoryEventContextFetcher;

protected:
    using TBase::TBase;

    const ITag* FetchTag(const TContextType& context) const;

    static const TString TypeNamePrefix;
};

class TTagIdContextFetcher: public ITagContextFetcher {
    using TBase = ITagContextFetcher;

public:
    using TBase::TBase;

    virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

    static TString GetTypeName();

private:
    using TRegistrator = TFactory::TRegistrator<TTagIdContextFetcher>;
    static TRegistrator Registrator;
};

class TTagNameContextFetcher: public ITagContextFetcher {
    using TBase = ITagContextFetcher;

public:
    using TBase::TBase;

    virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

    static TString GetTypeName();

private:
    using TRegistrator = TFactory::TRegistrator<TTagNameContextFetcher>;
    static TRegistrator Registrator;
};

class TTagDisplayNameContextFetcher: public ITagContextFetcher {
    using TBase = ITagContextFetcher;

public:
    using TBase::TBase;

    virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

    static TString GetTypeName();

private:
    using TRegistrator = TFactory::TRegistrator<TTagDisplayNameContextFetcher>;
    static TRegistrator Registrator;
};

class TTagCommentContextFetcher: public ITagContextFetcher {
    using TBase = ITagContextFetcher;

public:
    using TBase::TBase;

    virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

    static TString GetTypeName();

private:
    using TRegistrator = TFactory::TRegistrator<TTagCommentContextFetcher>;
    static TRegistrator Registrator;
};

class ISnapshotContextFetcher: public ICarTagHistoryEventContextFetcher {
    using TBase = ICarTagHistoryEventContextFetcher;

protected:
    using TBase::TBase;

    const THistoryDeviceSnapshot* FetchSnapshot(const TContextType& context) const;

    static const TString TypeNamePrefix;
};

class TSnapshotMileageContextFetcher: public ISnapshotContextFetcher {
    using TBase = ISnapshotContextFetcher;

public:
    using TBase::TBase;

    virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

    static TString GetTypeName();

private:
    using TRegistrator = TFactory::TRegistrator<TSnapshotMileageContextFetcher>;
    static TRegistrator Registrator;
};

class ICarContextFetcher: public ICarTagHistoryEventContextFetcher {
    using TBase = ICarTagHistoryEventContextFetcher;

protected:
    using TBase::TBase;

    bool FetchCar(const TContextType& context, TDriveCarInfo& carData) const;

    static const TString TypeNamePrefix;
};

class TCarModelContextFetcher: public ICarContextFetcher {
    using TBase = ICarContextFetcher;

public:
    using TBase::TBase;

    virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

    static TString GetTypeName();

private:
    using TRegistrator = TFactory::TRegistrator<TCarModelContextFetcher>;
    static TRegistrator Registrator;
};

class TCarNumberContextFetcher: public ICarContextFetcher {
    using TBase = ICarContextFetcher;

public:
    using TBase::TBase;

    virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

    static TString GetTypeName();

private:
    using TRegistrator = TFactory::TRegistrator<TCarNumberContextFetcher>;
    static TRegistrator Registrator;
};

class TCarVinContextFetcher: public ICarContextFetcher {
    using TBase = ICarContextFetcher;

public:
    using TBase::TBase;

    virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

    static TString GetTypeName();

private:
    using TRegistrator = TFactory::TRegistrator<TCarVinContextFetcher>;
    static TRegistrator Registrator;
};

class TCarIdContextFetcher: public ICarContextFetcher {
    using TBase = ICarContextFetcher;

public:
    using TBase::TBase;

    virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

    static TString GetTypeName();

private:
    using TRegistrator = TFactory::TRegistrator<TCarIdContextFetcher>;
    static TRegistrator Registrator;
};

class TCarInsurerContextFetcher: public ICarContextFetcher {
    using TBase = ICarContextFetcher;

public:
    using TBase::TBase;

    virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

    static TString GetTypeName();

private:
    using TRegistrator = TFactory::TRegistrator<TCarInsurerContextFetcher>;
    static TRegistrator Registrator;
};

class TCarUrlContextFetcher: public ICarContextFetcher {
    using TBase = ICarContextFetcher;

public:
    using TBase::TBase;

    virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

    static TString GetTypeName();

private:
    using TRegistrator = TFactory::TRegistrator<TCarUrlContextFetcher>;
    static TRegistrator Registrator;
};

class ICarParamByTagContextFetcher: public ICarContextFetcher {
    using TBase = ICarContextFetcher;

public:
    using TBase::TBase;
    virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

private:
    virtual TString GetParamKey() const = 0;

private:
    TString GetParamValue(const NDrive::IServer& server, const TMaybe<TString>& tagName, const TString& fallback) const;
};

class TCarCityContextFetcher: public ICarParamByTagContextFetcher {
    using TBase = ICarParamByTagContextFetcher;

public:
    using TBase::TBase;

    static TString GetTypeName();

private:
    virtual TString GetParamKey() const override;

private:
    using TRegistrator = TFactory::TRegistrator<TCarCityContextFetcher>;
    static TRegistrator Registrator;
};

class TCarPartnerContextFetcher: public ICarParamByTagContextFetcher {
    using TBase = ICarParamByTagContextFetcher;

public:
    using TBase::TBase;

    static TString GetTypeName();

private:
    virtual TString GetParamKey() const override;

private:
    using TRegistrator = TFactory::TRegistrator<TCarPartnerContextFetcher>;
    static TRegistrator Registrator;
};

class TCarFilterContextFetcherBase: public ICarContextFetcher {
    using TBase = ICarContextFetcher;

public:
    using TBase::TBase;

    virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override final;

private:
    virtual NJson::TJsonValue GetCarsFilterParameters(const TString& carId) const = 0;
};

class TCarAreaTagsCheckContextFetcher: public TCarFilterContextFetcherBase {
    using TBase = TCarFilterContextFetcherBase;

public:
    using TBase::TBase;

    static TString GetTypeName();

private:
    virtual NJson::TJsonValue GetCarsFilterParameters(const TString& carId) const override;

private:
    using TRegistrator = TFactory::TRegistrator<TCarAreaTagsCheckContextFetcher>;
    static TRegistrator Registrator;
};

class TCarAreaIdsCheckContextFetcher: public TCarFilterContextFetcherBase {
    using TBase = TCarFilterContextFetcherBase;

public:
    using TBase::TBase;

    static TString GetTypeName();

private:
    virtual NJson::TJsonValue GetCarsFilterParameters(const TString& carId) const override;

private:
    using TRegistrator = TFactory::TRegistrator<TCarAreaIdsCheckContextFetcher>;
    static TRegistrator Registrator;
};

