#pragma once

#include "definitions.h"

#include <drive/library/cpp/auth/tvm.h>
#include <rtline/util/network/neh.h>

namespace NDrive {

    class TCarsharingBackendClient {
    public:
        TCarsharingBackendClient(const TString& endpoint, IAuth::TPtr auth = nullptr);

        ~TCarsharingBackendClient() = default;

        NThreading::TFuture<TAreaInfosReport> GetAreaInfos(TDuration timeout = TDuration::Seconds(15)) const;
        NThreading::TFuture<NSignalq::TApiSignalqNotifySupportResponse> NotifySupport(const NSignalq::TApiSignalqNotifySupportRequest& requestParams, TDuration timeout = TDuration::Seconds(10)) const;

    private:
        THolder<NNeh::THttpClient> Client;
        IAuth::TPtr Auth;

        NThreading::TFuture<NJson::TJsonValue> DoRequest(NNeh::THttpRequest request, TDuration timeout, const TMaybe<NJson::TJsonValue>& requestBody = Nothing) const;
    };

}
