#include "definitions.h"

template <>
bool NJson::TryFromJson<NDrive::TAreaInfosReport>(const NJson::TJsonValue& json, NDrive::TAreaInfosReport& report) {
    return NJson::TryFromJson(json["areas"], report.Areas);
}

template <>
NJson::TJsonValue NJson::ToJson<NDrive::TAreaInfosReport>(const NDrive::TAreaInfosReport& report) {
    NJson::TJsonValue json;
    json["areas"] = NJson::ToJson(report.Areas);
    return json;
}

template <>
bool NJson::TryFromJson<NDrive::TAreaInfosReport::TArea>(const NJson::TJsonValue& json, NDrive::TAreaInfosReport::TArea& area) {
    return NJson::TryFromJson(json["area_id"], area.AreaId) &&
        NJson::TryFromJson(json["area_coords"], area.AreaCoords) &&
        NJson::TryFromJson(json["area_tags"], area.AreaTags);
}

template <>
NJson::TJsonValue NJson::ToJson<NDrive::TAreaInfosReport::TArea>(const NDrive::TAreaInfosReport::TArea& area) {
    NJson::TJsonValue json;
    json["area_id"] = area.AreaId;
    json["area_coords"] = NJson::ToJson(area.AreaCoords);
    json["area_tags"] = area.AreaTags;
    return json;
}

template <>
bool NJson::TryFromJson(const NJson::TJsonValue& value, NDrive::NSignalq::TApiSignalqNotifySupportResponse& result) {
    return
        NJson::ParseField(value, "added_tags_amount", result.MutableAddedTagsAmount(), true);
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NSignalq::TApiSignalqNotifySupportRequestEvent& object) {
    NJson::TJsonValue result = NJson::JSON_MAP;
    NJson::InsertField(result, "at", object.GetAt());
    NJson::InsertField(result, "type", object.GetType());
    NJson::InsertField(result, "alarm_raise_url", object.GetAlarmRaiseUrl());
    NJson::InsertNonNull(result, "video_url", object.OptionalVideoUrl());
    NJson::InsertNonNull(result, "external_video_url", object.OptionalExternalVideoUrl());
    NJson::InsertNonNull(result, "photo_url", object.OptionalPhotoUrl());
    NJson::InsertNonNull(result, "external_photo_url", object.OptionalExternalPhotoUrl());
    return result;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NSignalq::TApiSignalqNotifySupportRequestItem& object) {
    NJson::TJsonValue result = NJson::JSON_MAP;
    NJson::InsertField(result, "vin", object.GetVin());
    NJson::InsertField(result, "event", object.GetEvent());
    return result;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NSignalq::TApiSignalqNotifySupportRequest& object) {
    NJson::TJsonValue result = NJson::JSON_MAP;
    NJson::TJsonValue& itemsJson =  result.InsertValue("items", NJson::JSON_ARRAY);
    for (const auto& item : object.GetItems()) {
        itemsJson.AppendValue(NJson::ToJson(item));
    }
    return result;
}
