#pragma once

#include <library/cpp/json/json_reader.h>
#include <rtline/library/geometry/coord.h>
#include <rtline/library/json/parse.h>
#include <rtline/util/types/accessor.h>

namespace NDrive{

    struct TAreaInfosReport {
        struct TArea {
            TString AreaId;
            TVector<TGeoCoord> AreaCoords;
            TString AreaTags;
        };

        TVector<TArea> Areas;
    };

    namespace NSignalq{

        class TApiSignalqNotifySupportRequestEvent {
            R_FIELD(i64, At, -1);
            R_FIELD(TString, Type);
            R_OPTIONAL(TString, VideoUrl);
            R_OPTIONAL(TString, ExternalVideoUrl);
            R_OPTIONAL(TString, PhotoUrl);
            R_OPTIONAL(TString, ExternalPhotoUrl);
            R_FIELD(TString, AlarmRaiseUrl);
        };

        class TApiSignalqNotifySupportRequestItem {
            R_FIELD(TString, Vin);
            R_FIELD(TApiSignalqNotifySupportRequestEvent, Event);
        };

        class TApiSignalqNotifySupportRequest {
            R_FIELD(TVector<TApiSignalqNotifySupportRequestItem>, Items);
        };

        class TApiSignalqNotifySupportResponse {
            R_FIELD(ui32, AddedTagsAmount, 0);
        };

    } // namespace NSignalq

} // namespace NDrive
