#pragma once

#include "permission_tags.h"
#include "offer.h"

#include <drive/backend/data/common/serializable.h>
#include <drive/backend/data/common/temporary_tags.h>
#include <drive/backend/data/proto/tags.pb.h>

class TAccountTemporaryActionTag: public ITemporaryActionTag {
private:
    using TBase = ITemporaryActionTag;

private:
    static TFactory::TRegistrator<TAccountTemporaryActionTag> Registrator;
    static ITemporaryActionTag::TDescription::TFactory::TRegistrator<ITemporaryActionTag::TDescription> DescriptionRegistrator;

public:
    static const TString TypeName;
    R_FIELD(bool, Active, true);
    R_OPTIONAL(ui32, RequiredSum);

public:
    using TBase::TBase;

    virtual NEntityTagsManager::EEntityType GetEntityType() const override {
        return NEntityTagsManager::EEntityType::Account;
    }

public:

    virtual bool IsActive(bool isPotentiallyActive = false) const override;

    virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

    void SerializeSpecialDataToJson(NJson::TJsonValue& json) const override;
    bool DoSpecialDataFromJson(const NJson::TJsonValue& json, TMessagesCollector* errors) override;

    virtual TBase::TProto DoSerializeSpecialDataToProto() const override;
    virtual bool DoDeserializeSpecialDataFromProto(const TBase::TProto& proto) override;
};

class TSimpleAccountTag: public ISerializableTag<NDrive::NProto::TCommonTagData> {
private:
    using TBase = ISerializableTag<NDrive::NProto::TCommonTagData>;

public:
    static const TString TypeName;
    static TFactory::TRegistrator<TSimpleAccountTag> Registrator;

public:
    TSimpleAccountTag() = default;

    using TBase::TBase;

    virtual TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return { NEntityTagsManager::EEntityType::Account };
    }

    virtual EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::NoUnique;
    }
};

class TAdditionalRolesAccountTag: public TAdditionalRolesTag {
private:
    using TBase = TAdditionalRolesTag;

public:
    static const TString TypeName;
    static TFactory::TRegistrator<TAdditionalRolesAccountTag> Registrator;

public:
    using TBase::TBase;

    virtual TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return { NEntityTagsManager::EEntityType::Account };
    }
};

class TOfferHolderAccountTag : public TOfferHolderTag {
private:
    using TBase = TOfferHolderTag;

public:
    static TOptionalDBTags RestoreOfferHolderTags(
        TStringBuf behaviourConstructorId,
        TConstArrayRef<TString> tagNames,
        const NDrive::IServer& server,
        NDrive::TEntitySession& session
    );

public:
    using TBase::TBase;

    static TString Type() {
        return "offer_holder_organization_tag";
    }

    TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return { NEntityTagsManager::EEntityType::Account };
    }

private:
    static TFactory::TRegistrator<TOfferHolderAccountTag> Registrator;
};

class TExpiredDebtAccountTag : public ISerializableTag<NDrive::NProto::TExpiredDebtAccountTag> {
private:
    using TBase = ISerializableTag<NDrive::NProto::TExpiredDebtAccountTag>;

public:
    using TPtr = TAtomicSharedPtr<TExpiredDebtAccountTag>;

    enum class EDebtStatus {
        None = 0 /* "none" */,
        Warning = 1 /* "warning" */,
        Deactivate = 2 /* "deactivate" */,
    };

public:
    class TDescription : public TTagDescription {
    private:
        using TBase = TTagDescription;

    public:
        static constexpr ui64 DefaultWarningSinceMonthDay = 15;
        static constexpr ui64 DefaultDeactivateSinceMonthDay = 20;

    private:
        static TFactory::TRegistrator<TDescription> Registrator;

    public:
        NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

    protected:
        NJson::TJsonValue DoSerializeMetaToJson() const override;
        bool DoDeserializeMetaFromJson(const NJson::TJsonValue& jsonMeta) override;

    private:
        R_FIELD(ui64, WarningSinceMonthDay, DefaultWarningSinceMonthDay);
        R_FIELD(ui64, DeactivateSinceMonthDay, DefaultDeactivateSinceMonthDay);
        R_FIELD(bool, DeactivateAccount, false);
        R_FIELD(ui64, Gmt, 3);

        DECLARE_FIELDS(
            Field(WarningSinceMonthDay, "warning_since_month_day"),
            Field(DeactivateSinceMonthDay, "deactivate_since_month_day"),
            Field(DeactivateAccount, "deactivate_account"),
            Field(Gmt, "gmt")
        );
    };

public:
    static const TString TypeName;
    static TFactory::TRegistrator<TExpiredDebtAccountTag> Registrator;

public:
    TExpiredDebtAccountTag() = default;

    virtual TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return {NEntityTagsManager::EEntityType::Account};
    }

    virtual EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::Rewrite;
    }

    bool CalculateValues(const NDrive::IServer* server, NDrive::TEntitySession& session);
    bool MustBeDeactivated(const NDrive::IServer* server, NDrive::TEntitySession& session) const;

    TString SerializeToLog() const;
    bool IsEqual(const TExpiredDebtAccountTag& r) const;

    NJson::TJsonValue GetReport() const;

protected:
    bool DoSpecialDataFromJson(const NJson::TJsonValue& value, TMessagesCollector* errors) override;
    void SerializeSpecialDataToJson(NJson::TJsonValue& value) const override;

    NDrive::NProto::TExpiredDebtAccountTag DoSerializeSpecialDataToProto() const override;
    bool DoDeserializeSpecialDataFromProto(const NDrive::NProto::TExpiredDebtAccountTag& proto) override;

public:
    R_FIELD(bool, NeedWarning, false);
    R_FIELD(bool, NeedDeactivate, false);
    R_OPTIONAL(TInstant, FirstExpiredDT);
    R_OPTIONAL(ui64, DebtAmount);
    R_OPTIONAL(TInstant, WarningDate);
    R_OPTIONAL(TInstant, DeactivateDate);

    DECLARE_FIELDS(
        Field(NeedWarning, "need_warning"),
        Field(NeedDeactivate, "need_deactivate"),
        Field(FirstExpiredDT, "first_expired_dt"),
        Field(DebtAmount, "debt_amount")
    );
};
