#pragma once

#include <drive/backend/data/common/serializable.h>
#include <drive/backend/proto/tags.pb.h>
#include <drive/backend/roles/permissions.h>

class TAchievementUserTag : public ISerializableTag<NDrive::NProto::TAchievementUserTag> {
private:
    using TBase = ISerializableTag<NDrive::NProto::TAchievementUserTag>;

public:
    using TBase::TBase;

    class TDescription: public TTagDescription {
    public:
        using TBase = TTagDescription;

    private:
        R_FIELD(TString, ImageUrl);
        R_FIELD(TString, NoLevelImageUrl);
        R_FIELD(TString, AnimationUrl);
        R_FIELD(TString, NoLevelAnimationUrl);
        R_FIELD(TString, SharingVideoUrl);
        R_FIELD(double, MaxLevelValue, 0);
        R_FIELD(TString, TextColor);
        R_FIELD(TVector<TString>, GradientColor);
        R_FIELD(TString, ProgressValueColor);
        R_FIELD(TString, ProgressBgColor);
        R_FIELD(TString, NoLevelTextColor);
        R_FIELD(TVector<TString>, NoLevelGradientColor);
        R_FIELD(TString, NoLevelProgressValueColor);
        R_FIELD(TString, NoLevelProgressBgColor);
        R_FIELD(bool, Enabled, false);
        // EmptyEnabled marks achievement can be shown without tag.
        R_FIELD(bool, EmptyEnabled, false);
        // Priority represents priority of achievement.
        //
        // Large priority moves achievement to the top.
        // Small priority moves achievement to the bottom.
        R_FIELD(i32, Priority, 0);

    private:
        NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
        NJson::TJsonValue DoSerializeMetaToJson() const override;
        bool DoDeserializeMetaFromJson(const NJson::TJsonValue& json) override;

    private:
        static TFactory::TRegistrator<TDescription> Registrator;
    };

private:
    // Level contains current level.
    R_OPTIONAL(i32, Level);
    // LevelValue contains current level value for progress calculation.
    R_OPTIONAL(double, LevelValue);
    // LevelTimestamp contains timestamp of current achivement.
    R_OPTIONAL(TInstant, LevelTimestamp);

public:
    static const TString TypeName;

    TSet<NEntityTagsManager::EEntityType> GetObjectType() const override;

    EUniquePolicy GetUniquePolicy() const override;

    NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

    void SerializeSpecialDataToJson(NJson::TJsonValue& json) const override;
    bool DoSpecialDataFromJson(const NJson::TJsonValue& json, TMessagesCollector* errors) override;

    TProto DoSerializeSpecialDataToProto() const override;
    bool DoDeserializeSpecialDataFromProto(const TProto& proto) override;

    NJson::TJsonValue GetPublicReport(const NDrive::IServer& server, ELocalization localizationId) const;

    bool IsEnabled(const NDrive::IServer& server, TUserPermissions::TConstPtr permissions) const;

    bool IsEmptyEnabled(const NDrive::IServer& server, TUserPermissions::TConstPtr permissions) const;

    i32 GetPriority(const NDrive::IServer& server, TUserPermissions::TConstPtr permissions) const;

    static void Sort(TVector<TAchievementUserTag>& tags, const NDrive::IServer& server, TUserPermissions::TConstPtr permissions);

private:
    static TFactory::TRegistrator<TAchievementUserTag> Registrator;
};
