#pragma once

#include "offer.h"
#include "tag_with_subtags.h"

class TAdditionalServiceOffer;

class TAdditionalServiceOfferHolderTag: public TOfferHolderUserTag {
private:
    using TBase = TOfferHolderUserTag;

public:
    static const TString Planned;
    static const TString Starting;
    static const TString Started;

    class TDescription: public TTagWithSubtags::TDescription {
    private:
        using TBase = TTagWithSubtags::TDescription;

    public:
        using TBase::TBase;

        NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

    protected:
        NJson::TJsonValue DoSerializeMetaToJson() const override;
        bool DoDeserializeMetaFromJson(const NJson::TJsonValue& value) override;

    private:
        R_FIELD(bool, CheckDeposit, false);

        R_FIELD(bool, StartBillingTask, false);

        DECLARE_FIELDS(
            Field(CheckDeposit, "check_deposit"),
            Field(StartBillingTask, "start_billing_task")
        );
    };

    struct TBookOptions {
        bool CheckBlocked = true;
    };

public:
    static TOptionalDBTags RestoreOfferHolderTags(const TString& behaviourConstructorId, const NDrive::IServer& server, NDrive::TEntitySession& session);

    static TString Type() {
        return "additional_service_offer_holder_tag";
    }

public:
    static TDBTag Book(ICommonOffer::TPtr offer, const TUserPermissions& permissions, const NDrive::IServer& server, NDrive::TEntitySession& session, const TBookOptions& bookOptions);

    // Start starts additional service.
    static bool Start(
        const TDBTag& self,
        NDrive::TEntitySession& tx,
        const TAdditionalServiceOffer& offer,
        const TUserPermissions& permissions,
        const NDrive::IServer& server
    );

    // OnStarted add necessary tags on evolution to servicing.
    static bool OnStarted(
        const TDBTag& self,
        NDrive::TEntitySession& tx,
        TChargableTag& servicingTag,
        const TUserPermissions& permissions,
        const NDrive::IServer& server
    );

public:
    using TBase::TBase;

    bool ProvideDataOnEvolve(const TDBTag& from, const TUserPermissions& permissions, const NDrive::IServer* server, NDrive::TEntitySession& tx) override;
    bool OnAfterRemove(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& tx) const override;
    bool OnAfterEvolve(const TDBTag& from, ITag::TPtr to, const TUserPermissions& permissions, const NDrive::IServer* server, NDrive::TEntitySession& tx, const TEvolutionContext* eContext) const override;
    bool OnBeforeUpdate(const TDBTag& self, ITag::TPtr to, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& tx) const override;

protected:
    bool StartBillingTask(const NDrive::IServer* server, NDrive::TEntitySession& session) const;

    NDrive::NProto::TOfferHolderTag DoSerializeSpecialDataToProto() const override;
    bool DoDeserializeSpecialDataFromProto(const NDrive::NProto::TOfferHolderTag& proto) override;
    bool DoSpecialDataFromJson(const NJson::TJsonValue& value, TMessagesCollector* errors) override;

private:
    R_OPTIONAL(TString, ParentSessionId);
    //
    R_OPTIONAL(TVector<TGeoCoord>, DeliveryArea);
    R_OPTIONAL(TString, DeliveryLocationName);
    R_OPTIONAL(TGeoCoord, DeliveryLocation);
    R_OPTIONAL(bool, SameLocation);
    R_OPTIONAL(TInstant, ScheduledAt);

    DECLARE_FIELDS(
        Field(ParentSessionId, "parent_session_id"),
        Field(DeliveryArea, "delivery_area"),
        Field(DeliveryLocationName, "delivery_location_name"),
        Field(DeliveryLocation, "delivery_location"),
        Field(SameLocation, "same_location"),
        Field(ScheduledAt, "scheduled_at")
    );

private:
    static TFactory::TRegistrator<TAdditionalServiceOfferHolderTag> Registrator;
};
