#include "additional_service_session.h"

#include "additional_service.h"

#include <drive/backend/database/drive_api.h>

NJson::TJsonValue TAdditionalServiceSession::TCompilation::GetReport(ELocalization locale, const NDrive::IServer* server, ISessionReportCustomization::TPtr customization) const {
    Y_UNUSED(customization);
    NJson::TJsonValue result;
    if (Offer && server) {
        ICommonOffer::TReportOptions options;
        options.Locale = locale;
        result = Offer->BuildJsonReport(options, *server);
    }
    
    if (State && server) {
        auto stateReport = State->GetReport(locale, *server);
        NJson::MergeJson(stateReport, result);
    }

    result.InsertValue("session_tag_id", SessionTagId);
    result.InsertValue("session_id", SessionId);
    NJson::InsertNonNull(result, "parent_session_id", ParentSessionId);
    return result;
}

bool TAdditionalServiceSession::TCompilation::Fill(const TVector<TTimeEvent>& timeline, const TVector<TAtomicSharedPtr<TUserTagHistoryEvent>>& events) {
    if (!timeline.size()) {
        return false;
    }
    i32 lastTagEventIndex = -1;
    for (auto&& element : timeline) {
        if (element.GetTimeEvent() != IEventsSession<TCarTagHistoryEvent>::EEvent::Tag) {
            continue;
        }
        lastTagEventIndex = element.GetEventIndex();
    }
    if (lastTagEventIndex < 0) {
        return false;
    }
    const auto& event = events[lastTagEventIndex];
    const auto* tag = event->GetTagAs<TAdditionalServiceOfferHolderTag>();
    if (!tag) {
        return false;
    }
    SessionTagId = event->GetTagId();
    if (tag->HasParentSessionId()) {
        ParentSessionId = tag->GetParentSessionIdRef();
    }
    UserId = event->GetObjectId();
    Offer = std::dynamic_pointer_cast<TAdditionalServiceOffer>(tag->GetOffer());
    if (!Offer) {
        return false;
    }
    State = Offer->Calculate(timeline, events, Until);
    if (!State) {
        return false;
    }

    SessionId = Offer->GetOfferId();
    return true;
}

bool TAdditionalServiceSession::TestEvent(const TUserTagHistoryEvent& histEvent) const {
    Y_UNUSED(histEvent);
    return true;
}

NEventsSession::EEventCategory TAdditionalServiceSessionSelector::Accept(const TUserTagHistoryEvent& histEvent) const {
    if (histEvent.GetHistoryAction() == EObjectHistoryAction::Remove) {
        return NEventsSession::EEventCategory::End;
    }
    if (histEvent.GetHistoryAction() == EObjectHistoryAction::Add) {
        return NEventsSession::EEventCategory::Begin;
    }
    return NEventsSession::Internal;
}
