#pragma once

#include "device_tags.h"

#include <drive/backend/data/common/serializable.h>
#include <drive/backend/database/history/session.h>
#include <drive/backend/offers/offers/additional_service.h>
#include <drive/backend/proto/offer.pb.h>

#include <util/generic/map.h>

class TAdditionalServiceSessionSelector;

class TAdditionalServiceSession: public IEventsSession<TUserTagHistoryEvent> {
private:
    using TBase = IEventsSession<TUserTagHistoryEvent>;
    using ICompilation = typename TBase::ICompilation;
    using TTimeEvent = typename TBase::TTimeEvent;

public:
    class TCompilation: public ICompilation {
    private:
        R_FIELD(TInstant, Until, TInstant::Max());
        R_FIELD(TString, SessionTagId);
        TString SessionId;
        R_FIELD(TString, ParentSessionId);
        R_FIELD(TString, UserId);
        R_FIELD(TAtomicSharedPtr<TAdditionalServiceOffer>, Offer);
        R_FIELD(TOfferStatePtr, State);

    public:
        TCompilation()
        {
        }

        const TString& GetSessionId() const override {
            return SessionId;
        }

        virtual NJson::TJsonValue GetReport(ELocalization locale, const NDrive::IServer* server, ISessionReportCustomization::TPtr customization) const override;
        virtual bool Fill(const TVector<TTimeEvent>& timeline, const TVector<TAtomicSharedPtr<TUserTagHistoryEvent>>& events) override;
    };

    using TCompilationPtr = TAtomicSharedPtr<TCompilation>;
    using TSelector = TAdditionalServiceSessionSelector;

protected:
    virtual bool TestEvent(const TUserTagHistoryEvent& histEvent) const override;

public:
    TAdditionalServiceSession()
    {
    }

    THolder<ICompilation> BuildDefaultCompilation() const override {
        return MakeHolder<TCompilation>();
    }

protected:
    virtual TUniquePtr DoClone() const override {
        return MakeHolder<TAdditionalServiceSession>(*this);
    }

};

class TAdditionalServiceSessionSelector: public ISessionSelector<TUserTagHistoryEvent> {
private:
    using TBase = ISessionSelector<TUserTagHistoryEvent>;
    const IDriveTagsManager& TagsManager;

public:
    TAdditionalServiceSessionSelector(const IDriveTagsManager& tagsManager)
        : TagsManager(tagsManager)
    {
        Y_UNUSED(TagsManager);
    }

    virtual TString GetName() const override {
        return "additional_service";
    }

    virtual IEventsSession<TUserTagHistoryEvent>::TPtr BuildSession() const override {
        return new TAdditionalServiceSession();
    }

    virtual NEventsSession::EEventCategory Accept(const TUserTagHistoryEvent& e) const override;
};
