#include "absent_cars.h"

#include <drive/backend/abstract/base.h>

bool TAbsentCarsInfo::Initialize(TMessagesCollector* errors) {
    const NDrive::IServer* server = Traces.GetServer();
    CHECK_WITH_LOG(!!server->GetDriveAPI());
    DriveCars = server->GetDriveAPI()->GetCarsData()->FetchInfo().GetResult();
    if (!DriveCars.size()) {
        if (errors) {
            errors->AddMessage("drive reply", "Incorrect reply from drive (no info about cars)");
        }
        ERROR_LOG << "Cannot fetch data from drive database";
        return false;
    }
    TSet<TString> carsExists;
    for (auto&& i : Traces.GetTraces()) {
        carsExists.insert(i.GetDeviceId());
    }
    for (auto&& i : DriveCars) {
        if (!carsExists.contains(i.second.GetId())) {
            AbsentCars.push_back(i.second);
        }
    }
    return true;
}

NJson::TJsonValue TAbsentCarsInfo::GetReportAbsent() const {
    NJson::TJsonValue noExistsCars = NJson::TJsonValue(NJson::JSON_ARRAY);
    for (auto&& i : AbsentCars) {
        noExistsCars.AppendValue(i.GetReport(DefaultLocale, NDeviceReport::EReportTraits::ReportStatus | NDeviceReport::EReportTraits::ReportCarId));
    }
    return noExistsCars;
}
