#pragma once
#include "traces.h"

#include <drive/backend/database/drive_api.h>

#include <library/cpp/json/writer/json_value.h>

#include <rtline/protos/proto_helper.h>

#include <util/generic/ptr.h>

class TMessagesCollector;

class TAbsentCarsInfo {
private:
    TMap<TString, TDriveCarInfo> DriveCars;
    const TTracesAccessor& Traces;
    TVector<TDriveCarInfo> AbsentCars;
public:
    TAbsentCarsInfo(const TTracesAccessor& traces)
        : Traces(traces)
    {
    }

    const TMap<TString, TDriveCarInfo>& GetDriveCars() const {
        return DriveCars;
    }

    const TVector<TDriveCarInfo>& GetAbsentCars() const {
        return AbsentCars;
    }

    bool Initialize(TMessagesCollector* errors = nullptr);

    NJson::TJsonValue GetReportAbsent() const;
};
