#pragma once

#include <drive/backend/processors/common_app/config.h>

#include <drive/backend/auth/common/auth.h>

class TAlertsConfig {
private:
    double DistanceMovingCheckerForStoppedCars = 100;
    double CriticalLengthForViolationDetect = 500;
    TDuration DurationForDetectDeadTracks = TDuration::Minutes(15);

public:
    TDuration GetDurationForDetectDeadTracks() const {
        return DurationForDetectDeadTracks;
    }

    double GetCriticalLengthForViolationDetect() const {
        return CriticalLengthForViolationDetect;
    }

    double GetDistanceMovingCheckerForStoppedCars() const {
        return DistanceMovingCheckerForStoppedCars;
    }

    void Init(const TYandexConfig::Section* section) {
        DistanceMovingCheckerForStoppedCars = section->GetDirectives().Value("DistanceMovingCheckerForStoppedCars", DistanceMovingCheckerForStoppedCars);
        CriticalLengthForViolationDetect = section->GetDirectives().Value("CriticalLengthForViolationDetect", CriticalLengthForViolationDetect);
        DurationForDetectDeadTracks = section->GetDirectives().Value("DurationForDetectDeadTracks", DurationForDetectDeadTracks);
    }

    void ToString(IOutputStream& os) const {
        os << "DistanceMovingCheckerForStoppedCars: " << DistanceMovingCheckerForStoppedCars << Endl;
        os << "CriticalLengthForViolationDetect: " << CriticalLengthForViolationDetect << Endl;
        os << "DurationForDetectDeadTracks: " << DurationForDetectDeadTracks << Endl;
    }
};
