#include "tags.h"

#include <rtline/library/graph/geometry_graph/common/types.h>

const TString TTagLowVoltage::TagName = "low_voltage";

TTagLowVoltage::TFactory::TRegistrator<TTagLowVoltage> TTagLowVoltage::Registrator(TTagLowVoltage::TagName);

const TString TTagNoSignal::TagName = "no_signal";

TTagNoSignal::TFactory::TRegistrator<TTagNoSignal> TTagNoSignal::Registrator(TTagNoSignal::TagName);

const TString TTagIncorrectRidingZone::TagName = "incorrect_rzone";

TTagIncorrectRidingZone::TFactory::TRegistrator<TTagIncorrectRidingZone> TTagIncorrectRidingZone::Registrator(TTagIncorrectRidingZone::TagName);

const TString TTagIncorrectMoving::TagName = "incorrect_moving";

TTagIncorrectMoving::TFactory::TRegistrator<TTagIncorrectMoving> TTagIncorrectMoving::Registrator(TTagIncorrectMoving::TagName);

const TString TTagIncorrectVelocity::TagName = "incorrect_v";

TTagIncorrectVelocity::TFactory::TRegistrator<TTagIncorrectVelocity> TTagIncorrectVelocity::Registrator(TTagIncorrectVelocity::TagName);

TString TTagIncorrectVelocity::GetHRDescription() const {
    return "превышение скорости на " + Sprintf("%.1f", TSpeedWithUnit::MS(VDelta).KmH()) + " км/ч на протяжении " + Sprintf("%0.0f", Length) + " м за последние " + ToString(Duration.Minutes()) + " минут";
}

void TTagIncorrectVelocity::SerializeSpecialDataToJson(NJson::TJsonValue& json) const {
    TTraceTag::SerializeSpecialDataToJson(json);
    json.InsertValue("velocity_delta", Sprintf("%.1f", TSpeedWithUnit::MS(VDelta).KmH()));
    json.InsertValue("length", Sprintf("%0.0f", Length));
    json.InsertValue("duration", Duration.Seconds());
    json.InsertValue("minutes", Duration.Minutes());
}

TString TTagIncorrectMoving::GetHRDescription() const {
    return "некорректное состояние для движения в течение последних " + ToString(Duration.Minutes()) + " минут";
}

TString TTagIncorrectRidingZone::GetHRDescription() const {
    return "машина находится в некорректной области";
}

TString TTagNoSignal::GetHRDescription() const {
    return "отсутствует или некорректный сигнал от машины";
}

TString TTagLowVoltage::GetHRDescription() const {
    return "пониженное напряжение: " + ToString(Voltage);
}

