#include "coloring.h"

#include <library/cpp/json/json_reader.h>

#include <rtline/util/json_processing.h>

const TString TPropertiesPatchTag::TypeName = "properties_patch_tag";
ITag::TFactory::TRegistrator<TPropertiesPatchTag> TPropertiesPatchTag::Registrator(TPropertiesPatchTag::TypeName);
TPropertiesPatchTag::TDescription::TFactory::TRegistrator<TPropertiesPatchTag::TDescription> TPropertiesPatchTag::TDescription::Registrator(TPropertiesPatchTag::TypeName);


void TPropertiesPatchTag::TDescription::ApplyForJson(NJson::TJsonValue& report) const {
    for (auto&& i : Patches) {
        NJson::TJsonValue jsonValue;
        if (NJson::ReadJsonFastTree(i.second.GetValue(), &jsonValue)) {
            report[i.second.GetKey()] = std::move(jsonValue);
        } else {
            report[i.second.GetKey()] = i.second.GetValue();
        }
    }
}

NDrive::TScheme TPropertiesPatchTag::TDescription::GetScheme(const NDrive::IServer* server) const {
    NDrive::TScheme result = TTagDescription::GetScheme(server);
    NDrive::TScheme& iPatch = result.Add<TFSArray>("patches", "Патчи для машины").SetElement<NDrive::TScheme>();
    iPatch.Add<TFSString>("key", "Ключ");
    iPatch.Add<TFSString>("value", "Значение");

    return result;
}

NJson::TJsonValue TPropertiesPatchTag::TDescription::DoSerializeMetaToJson() const {
    NJson::TJsonValue jsonMeta(NJson::JSON_MAP);
    NJson::TJsonValue& patches = jsonMeta.InsertValue("patches", NJson::JSON_ARRAY);
    for (auto&& i : Patches) {
        patches.AppendValue(i.second.SerializeToJson());
    }
    return jsonMeta;
}

bool TPropertiesPatchTag::TDescription::DoDeserializeMetaFromJson(const NJson::TJsonValue& jsonMeta) {
    if (jsonMeta.Has("patches")) {
        const NJson::TJsonValue::TArray* arr;
        if (!jsonMeta["patches"].GetArrayPointer(&arr)) {
            return false;
        }
        for (auto&& i : *arr) {
            TPatchDescription pd;
            if (!pd.DeserializeFromJson(i)) {
                return false;
            }
            Patches.emplace(pd.GetKey(), std::move(pd));
        }
    }
    return Patches.size();
}

bool TPropertiesPatchTag::TDescription::TPatchDescription::DeserializeFromJson(const NJson::TJsonValue& info) {
    JREAD_STRING(info, "key", Key);
    JREAD_STRING(info, "value", Value);
    return !!Key;
}

NJson::TJsonValue TPropertiesPatchTag::TDescription::TPatchDescription::SerializeToJson() const {
    NJson::TJsonValue result;
    JWRITE(result, "key", Key);
    JWRITE(result, "value", Value);
    return result;
}
