#pragma once

#include <drive/backend/data/common/serializable.h>
#include <drive/backend/proto/tags.pb.h>
#include <drive/backend/tags/tag_description.h>

class TPropertiesPatchTag: public ISerializableTag<NDrive::NProto::TCommonTagData> {
private:
    using TBase = ISerializableTag<NDrive::NProto::TCommonTagData>;

public:
    static const TString TypeName;
    static TFactory::TRegistrator<TPropertiesPatchTag> Registrator;

public:
    class TDescription: public TTagDescription {
    private:
        class TPatchDescription {
            R_FIELD(TString, Key);
            R_FIELD(TString, Value);

        public:
            TPatchDescription() = default;
            TPatchDescription(const TString& key, const TString& value)
                : Key(key)
                , Value(value)
            {
            }

            bool DeserializeFromJson(const NJson::TJsonValue& info);
            NJson::TJsonValue SerializeToJson() const;
        };

    private:
        TMap<TString, TPatchDescription> Patches;

    private:
        static TFactory::TRegistrator<TDescription> Registrator;

    public:
        void ApplyForJson(NJson::TJsonValue& report) const;

        TString GetPatch(const TString& key) const {
            auto it = Patches.find(key);
            if (it == Patches.end()) {
                return "";
            } else {
                return it->second.GetValue();
            }
        }

        TDescription& AddPatch(const TString& key, const TString& value) {
            Patches.emplace(key, TPatchDescription(key, value));
            return *this;
        }

        virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

        virtual NJson::TJsonValue DoSerializeMetaToJson() const override;
        virtual bool DoDeserializeMetaFromJson(const NJson::TJsonValue& jsonMeta) override;
    };

    virtual EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::NoUnique;
    }

    virtual TTagDescription::TPtr GetMetaDescription(const TString& /*type*/) const override {
        return nullptr;
    }

    virtual TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return{NEntityTagsManager::EEntityType::Car};
    }
};
