#pragma once

#include <drive/backend/tags/tags.h>

class TCommonTag: public NDrive::ITag {
private:
    using TBase = NDrive::ITag;

public:
    using TBase::TBase;

    virtual TAggregateEvolutionPolicy BuildCustomEvolutionPolicy(
        const TConstDBTag& dbTag,
        ITag::TPtr newTag,
        const NDrive::IServer* server,
        const TUserPermissions& permissions,
        const NJson::TJsonValue& requestData,
        const EEvolutionMode eMode,
        NDrive::TEntitySession& session
    ) const override;
    virtual bool CopyOnEvolve(const ITag& source, const TTagEvolutionAction* evolution, const NDrive::IServer& server) override;

    TAtomicSharedPtr<const TTagDescription> GetDescription(const NDrive::IServer& server) const;
    TAtomicSharedPtr<const TTagDescription> GetDescription(const NDrive::IServer& server, NDrive::TEntitySession& session) const;
    template <class T>
    TAtomicSharedPtr<const T> GetDescriptionAs(const NDrive::IServer& server) const {
        return std::dynamic_pointer_cast<const T>(GetDescription(server));
    }
    template <class T>
    TAtomicSharedPtr<const T> GetDescriptionAs(const NDrive::IServer& server, NDrive::TEntitySession& session, bool polite = false) const {
        auto d = GetDescription(server, session);
        if (!d) {
            return nullptr;
        }
        auto result = std::dynamic_pointer_cast<const T>(d);
        if (!result && !polite) {
            session.SetErrorInfo("GetDescription", "cannot cast description " + d->GetName() + " as " + TypeName<T>());
            return nullptr;
        }
        return result;
    }
};
