#pragma once

#include <drive/backend/data/common/serializable.h>
#include <drive/backend/data/proto/tags.pb.h>

class TCommunicationChannelSettings {
    R_READONLY(bool, IgnoreSubscriptionStatus, false);

public:
    void FillScheme(NDrive::TScheme& scheme) const;
    void SerializeToJson(NJson::TJsonValue& json) const;
    bool DeserializeFromJson(const NJson::TJsonValue& json);
};

class TLandingUserTag: public ISerializableTag<NDrive::NProto::TLandingUserTagData> {
private:
    using TBase = ISerializableTag<NDrive::NProto::TLandingUserTagData>;
    using TProtoPair = NDrive::NProto::TLandingUserTagData::TPair;

public:
    static const TString TypeName;
    static TFactory::TRegistrator<TLandingUserTag> Registrator;

public:
    using TBase::TBase;
    using TParametersMap = TMap<TString, TString>;

    R_FIELD(TParametersMap, ContextParameters);

public:
    class TDescription: public TTagDescription {
    private:
        using TBase = TTagDescription;

    public:
        R_FIELD(TString, LandingId);
        R_FIELD(TLandingUserTag::TParametersMap, DefaultContextParameters);
        R_FIELD(TCommunicationChannelSettings, CommunicationChannelSettings);
        R_FIELD(bool, Disposable, true);

    private:
        static TFactory::TRegistrator<TDescription> Registrator;

    public:
        using TBase::TBase;

        virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
        virtual NJson::TJsonValue DoSerializeMetaToJson() const override;
        virtual bool DoDeserializeMetaFromJson(const NJson::TJsonValue& jsonMeta) override;
    };

    virtual EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::NoUnique;
    }

    virtual TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return {NEntityTagsManager::EEntityType::User};
    }

    bool SetContextParameter(const TString& key, const TString& value) {
        return ContextParameters.emplace(key, value).second;
    }

public:
    void SerializeSpecialDataToJson(NJson::TJsonValue& json) const override;
    bool DoSpecialDataFromJson(const NJson::TJsonValue& json, TMessagesCollector* errors) override;
    TMaybe<NJson::TJsonValue> SubstituteTemplate(const NJson::TJsonValue& templateJson, const NDrive::IServer* server, const TString& escPrefix = "[", const TString& escSuffix = "]") const;
    virtual NDrive::NProto::TLandingUserTagData DoSerializeSpecialDataToProto() const override;
    virtual bool DoDeserializeSpecialDataFromProto(const NDrive::NProto::TLandingUserTagData& proto) override;
    virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
};
