#pragma once

#include <drive/backend/data/common/serializable.h>
#include <drive/backend/data/proto/tags.pb.h>

class IEntityTagsManager;

class IContainerTag: public INativeSerializationTag<NDrive::NProto::IContainerTag> {
private:
    using TBase = INativeSerializationTag<NDrive::NProto::IContainerTag>;
    TString StoredTagType;
    TString StoredTagData;

protected:
    virtual TProto DoSerializeSpecialDataToProto() const override;
    virtual bool DoDeserializeSpecialDataFromProto(const TProto& proto) override;
    void SetStoredTag(ITag::TConstPtr tag);

public:
    using TBase::TBase;

    virtual bool ProvideDataOnEvolve(const TDBTag& fromTag, const TUserPermissions& /*permissions*/, const NDrive::IServer* /*server*/, NDrive::TEntitySession& session) override {
        if (!fromTag) {
            session.SetErrorInfo("container", "ProvideDataOnEvolve", EDriveSessionResult::InconsistencyUser);
            return false;
        }
        SetStoredTag(fromTag.GetData());
        return true;
    }

    bool OnSLAExpired(const TDBTag& dbTag, const TUserPermissions& permissions, const IEntityTagsManager* manager, const NDrive::IServer* server, NDrive::TEntitySession& session) const override;

    ITag::TPtr RestoreTag() const;

    virtual EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::NoUnique;
    }

    static TMaybe<TDBTag> UndeferContainer(const TDBTag& tag, TUserPermissionsConstPtr permissions, const NDrive::IServer* server, const IEntityTagsManager& tagsManager, NDrive::TEntitySession& session);
};

class TUserContainerTag : public IContainerTag {
private:
    using TBase = IContainerTag;
    static TFactory::TRegistrator<TUserContainerTag> Registrator;

public:
    using TBase::TBase;
    static const TString TypeName;

    TUserContainerTag() = default;

    virtual TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return{NEntityTagsManager::EEntityType::User};
    }
};

class TCarContainerTag : public IContainerTag {
private:
    using TBase = IContainerTag;
    static TFactory::TRegistrator<TCarContainerTag> Registrator;

public:
    using TBase::TBase;
    static const TString TypeName;

    TCarContainerTag() = default;

    virtual TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return{NEntityTagsManager::EEntityType::Car};
    }
};
