#pragma once

#include "delivery.h"
#include "account_tags.h"
#include "organization_tag.h"
#include "tag_with_subtags.h"
#include "support_tags.h"

#include <drive/backend/offers/offers/dedicated_fleet.h>


class TSpecialFleetTag : public ISerializableTag<NDrive::NProto::TSpecialFleetTagData>, public IOrganizationTag {
    using TBase = ISerializableTag<NDrive::NProto::TSpecialFleetTagData>;

public:
    static const TString TypeName;
    static TFactory::TRegistrator<TSpecialFleetTag> Registrator;

    static const TString Hold;
    static const TString Preparing;
    static const TString Prepared;
    static const TString Delivery;
    static const TString Actual;

public:
    using TBase::TBase;
    using TPtr = TAtomicSharedPtr<TSpecialFleetTag>;

    NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

    EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::NoUnique;
    }

    TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return {NEntityTagsManager::EEntityType::Car};
    }

    bool OnBeforeRemove(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) override;
    bool OnBeforeEvolve(const TDBTag& fromTag, ITag::TPtr toTag, const TUserPermissions& permissions, const NDrive::IServer* server, NDrive::TEntitySession& session, const TEvolutionContext* eContext) const override;

    bool GetFleetUnitOffer(TDedicatedFleetUnitOffer::TPtr& unitOffer,const TString& id, const NDrive::IServer* server, NDrive::TEntitySession& session,  const TDedicatedFleetOffer::TPtr offer = nullptr) const;
    bool GetFleetOffer(TDedicatedFleetOffer::TPtr& offer, const NDrive::IServer* server, NDrive::TEntitySession& session) const;

private:
    virtual void SerializeSpecialDataToJson(NJson::TJsonValue& json) const override;
    virtual bool DoSpecialDataFromJson(const NJson::TJsonValue& jsonValue, TMessagesCollector* errors) override;

protected:
    virtual TProto DoSerializeSpecialDataToProto() const override;
    virtual bool DoDeserializeSpecialDataFromProto(const TProto& proto) override;

private:
    R_FIELD(TString, OfferId);
    R_FIELD(TString, UnitOfferId);
    R_FIELD(TVector<TString>, OnAssignAddedTags);
    R_FIELD(TVector<TString>, OnAssignEvolvedTags);
    R_FIELD(TString, OfferHolderTagId);

    DECLARE_FIELDS(
        Field(OfferId, "offer_id"),
        Field(UnitOfferId, "unit_offer_id"),
        Field(OnAssignAddedTags, "on_assign_added_tags"),
        Field(OnAssignEvolvedTags, "on_assign_evolved_tags"),
        Field(OfferHolderTagId, "offer_holder_tag_id")
    );
};

class TDedicatedFleetOfferHolderTag : public TOfferHolderAccountTag, public TTagWithSubtags {
private:
    using TBase = TOfferHolderAccountTag;

public:
    using TPtr = TAtomicSharedPtr<TDedicatedFleetOfferHolderTag>;
    using TConstPtr = TAtomicSharedPtr<const TDedicatedFleetOfferHolderTag>;

public:
    class TDescription: public TTagWithSubtags::TDescription {
    private:
        using TBase = TTagWithSubtags::TDescription;

    private:
        static TFactory::TRegistrator<TDescription> Registrator;

    public:
        NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

    protected:
        NJson::TJsonValue DoSerializeMetaToJson() const override;
        bool DoDeserializeMetaFromJson(const NJson::TJsonValue& jsonMeta) override;

    private:
        R_FIELD(TString, CommunicationTag);
        R_FIELD(TString, FleetTag);
        R_FIELD(bool, StartBillingTask, false);
        R_FIELD(TString, EvolveTargetSuffix, "_dedicated_fleet");
        R_FIELD(TSet<TString>, TagsToEvolveWithSuffix);

        DECLARE_FIELDS(
            Field(CommunicationTag, "communication_tag"),
            Field(FleetTag, "fleet_tag"),
            Field(StartBillingTask, "start_billing_task"),
            Field(EvolveTargetSuffix, "evolve_target_suffix"),
            Field(TagsToEvolveWithSuffix, "tags_to_evolve_with_suffix")
        );
    };

    struct TBookOptions {
        bool CheckBlocked = true;
    };

public:
    static TString Type() {
        return "dedicated_fleet_offer_holder_tag";
    }

    static TDBTag Book(ICommonOffer::TPtr offer, const TUserPermissions& permissions, const NDrive::IServer& server, NDrive::TEntitySession& session, const TBookOptions& bookOptions);

public:
    bool OnBeforeAdd(const TString& objectId, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) override;
    bool OnAfterAdd(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const override;
    bool OnBeforeUpdate(const TDBTag& self, ITag::TPtr to, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const override;
    bool OnAfterUpdate(const TDBTag& self, ITag::TPtr toTag, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const override;
    bool OnBeforeRemove(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) override;
    bool OnAfterRemove(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const override;

public:
    using TBase::TBase;

protected:
    bool DoDeferredClean(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const;
    bool UpdateUnitOffer(const TDBTag& selfTag, const TDedicatedFleetUnitOffer::TPtr& selfUOffer, const TDedicatedFleetUnitOffer::TPtr& toUOffer, const TUserPermissions& permissions, const NDrive::IServer* server, NDrive::TEntitySession& session, bool force) const;
    bool AddCar(const TDBTag& selfTag, const TString& carId, const TString& offerId, const TUserPermissions& permissions, const NDrive::IServer* server, NDrive::TEntitySession& session) const;
    bool RemoveCar(const TDBTag& selfTag, const TString& carId, const TUserPermissions& permissions, const NDrive::IServer* server, NDrive::TEntitySession& session, bool force) const;

    TSpecialFleetTag::TPtr PrepareFleetTag(const TDBTag& selfTag, const TString& offerId, const NDrive::IServer* server, NDrive::TEntitySession& session) const;

    bool DoSpecialDataFromJson(const NJson::TJsonValue& value, TMessagesCollector* errors) override;
    void SerializeSpecialDataToJson(NJson::TJsonValue& value) const override;

    NDrive::NProto::TOfferHolderTag DoSerializeSpecialDataToProto() const override;
    bool DoDeserializeSpecialDataFromProto(const NDrive::NProto::TOfferHolderTag& proto) override;

    NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

private:
    bool BuildOfferFromTagData(const TString& objectId, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session);

private:
    R_FIELD(TString, CommunicationTagId);
    R_FIELD(TSet<TString>, FleetTagIds);
    R_FIELD(bool, ConstructOffer, false);
    R_FIELD(ui64, FleetSize, 0);
    R_FIELD(TString, Builder);
    R_FIELD(TSet<TString>, TagsForDeferredCleanup, {}, mutable);

    DECLARE_FIELDS(
        Field(CommunicationTagId, "communication_tag_id"),
        Field(FleetTagIds, "fleet_tag_ids"),
        Field(ConstructOffer, "construct_offer"),
        Field(FleetSize, "fleet_size"),
        Field(Builder, "builder")
    );

private:
    static TFactory::TRegistrator<TDedicatedFleetOfferHolderTag> Registrator;
};

class TFleetSupportOutgoingCommunicationTag : public TSupportOutgoingCommunicationTag
{
private:
    using TBase = TSupportOutgoingCommunicationTag;
    using TDescriptionBase = TBase::TDescription;

public:
    static const TString TypeName;
    static TFactory::TRegistrator<TFleetSupportOutgoingCommunicationTag> Registrator;

public:
    using TBase::TBase;

public:
    virtual EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::NoUnique;
    }

    virtual TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return {NEntityTagsManager::EEntityType::User};
    }

    bool OnAfterEvolve(const TDBTag& from, ITag::TPtr to, const TUserPermissions& permissions, const NDrive::IServer* server, NDrive::TEntitySession& session, const TEvolutionContext* eContext) const override;
    bool OnBeforeEvolve(const TDBTag& from, ITag::TPtr to, const TUserPermissions& permissions, const NDrive::IServer* server, NDrive::TEntitySession& session, const TEvolutionContext* eContext) const override;

protected:
    TProto DoSerializeSpecialDataToProto() const override;
    bool DoDeserializeSpecialDataFromProto(const TProto& proto) override;

    void SerializeSpecialDataToJson(NJson::TJsonValue& json) const override;
    bool DoSpecialDataFromJson(const NJson::TJsonValue& json, TMessagesCollector* errors) override;
};

class TFleetDeliveryTag : public TCarDeliveryTag {
private:
    using TBase = TCarDeliveryTag;

public:
    static TString Type() {
        return "fleet_car_delivery_tag";
    }

public:
    using TBase::TBase;
    using TBase::TDescription;

    bool OnBeforeAdd(const TString& objectId, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) override;
    bool OnBeforePerform(TDBTag& self, const TUserPermissions& permissions, const NDrive::IServer* server, NDrive::TEntitySession& session) override;
    bool OnAfterRemove(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const override;

protected:
    virtual bool DoSpecialDataFromJson(const NJson::TJsonValue& value, TMessagesCollector* errors) override;
    virtual void SerializeSpecialDataToJson(NJson::TJsonValue& value) const override;

    bool GetFleetTag(TSpecialFleetTag::TPtr& tag, const TString& id, const NDrive::IServer* server, NDrive::TEntitySession& session) const;

private:
    R_FIELD(TString, FleetTagId);

    DECLARE_FIELDS(
        Field(FleetTagId, "fleet_tag_id")
    );

private:
    static TFactory::TRegistrator<TFleetDeliveryTag> Registrator;
};
