#include "dedicated_fleet_session.h"

#include "dedicated_fleet.h"

#include <drive/backend/database/drive_api.h>

NJson::TJsonValue TDedicatedFleetSession::TCompilation::GetReport(ELocalization locale, const NDrive::IServer* server, ISessionReportCustomization::TPtr customization) const {
    Y_UNUSED(customization);

    NJson::TJsonValue result;
    result.InsertValue("session_tag_id", SessionTagId);
    result.InsertValue("session_id", SessionId);
    result.InsertValue("account_id", AccountId);
    if (State && server) {
        auto stateReport = State->GetReport(locale, *server);
        NJson::MergeJson(stateReport, result);
    }

    if (Offer) {
        auto offerReport = Offer->BuildJsonReport(ICommonOffer::TReportOptions{}, *server);
        result.InsertValue("offer", offerReport);
    }

    return result;
}

bool TDedicatedFleetSession::TCompilation::Fill(const TVector<TTimeEvent>& timeline, const TVector<TAtomicSharedPtr<TAccountTagHistoryEvent>>& events) {
    if (!timeline.size()) {
        return false;
    }

    TDedicatedFleetOfferHolderTag::TConstPtr holderTag;
    TAtomicSharedPtr<TAccountTagHistoryEvent> event;
    for (auto&& element : timeline) {
        if (element.GetTimeEvent() != IEventsSession<TTagHistoryEvent>::EEvent::Tag) {
            continue;
        }

        event = events[element.GetEventIndex()];
        if (auto tag = std::dynamic_pointer_cast<const TDedicatedFleetOfferHolderTag>(event->GetData())) {
            holderTag = tag;
        }
    }

    if (!holderTag) {
        return false;
    }

    Offer = std::dynamic_pointer_cast<TDedicatedFleetOffer>(holderTag->GetOffer());
    if (!Offer) {
        return false;
    }

    SessionTagId = event->GetTagId();
    AccountId = event->GetObjectId();
    SessionId = Offer->GetOfferId();

    State = Offer->Calculate(timeline, events, Until);
    if (!State) {
        return false;
    }

    SessionId = Offer->GetOfferId();

    return true;
}

bool TDedicatedFleetSession::TestEvent(const TAccountTagHistoryEvent& histEvent) const {
    Y_UNUSED(histEvent);
    return true;
}

NEventsSession::EEventCategory TDedicatedFleetSessionSelector::Accept(const TTagHistoryEvent& event) const {
    return AcceptImpl(event);
}

NEventsSession::EEventCategory TDedicatedFleetSessionSelector::AcceptImpl(const TTagHistoryEvent& event) {
    if (event->GetName() != TDedicatedFleetOfferHolderTag::Type()) {
        return NEventsSession::Internal;
    }

    if (event.GetHistoryAction() == EObjectHistoryAction::Remove) {
        return NEventsSession::EEventCategory::End;
    }

    if (event.GetHistoryAction() == EObjectHistoryAction::Add) {
        return NEventsSession::EEventCategory::Begin;
    }

    return NEventsSession::Internal;
}
