#pragma once

#include "device_tags.h"

#include <drive/backend/data/common/serializable.h>
#include <drive/backend/database/history/session.h>
#include <drive/backend/offers/offers/dedicated_fleet.h>
#include <drive/backend/proto/offer.pb.h>

#include <util/generic/map.h>

class TDedicatedFleetSessionSelector;
class TDedicatedFleetUnitSessionSelector;

class TDedicatedFleetSession : public IEventsSession<TTagHistoryEvent> {
private:
    using TBase = IEventsSession<TTagHistoryEvent>;
    using ICompilation = typename TBase::ICompilation;
    using TTimeEvent = typename TBase::TTimeEvent;

    using TSession = IEventsSession<TTagHistoryEvent>;
    using TSessionConstPtr = TAtomicSharedPtr<const TSession>;
    using TConstSessions = TVector<TSessionConstPtr>;

public:
    using TOfferStatePtr = TAtomicSharedPtr<IOfferState>;
    using TOfferStates = TVector<TOfferStatePtr>;

public:
    class TCompilation : public ICompilation {
    private:
        R_FIELD(TInstant, Until, TInstant::Max());
        R_FIELD(TString, SessionTagId);
        R_FIELD(TString, AccountId);
        R_FIELD(TAtomicSharedPtr<TDedicatedFleetOffer>, Offer);
        R_FIELD(TOfferStatePtr, State);

    private:
        TString SessionId;

    public:
        TCompilation() = default;

        const TString& GetSessionId() const override {
            return SessionId;
        }

        NJson::TJsonValue GetReport(ELocalization locale, const NDrive::IServer* server, ISessionReportCustomization::TPtr customization) const override;
        bool Fill(const TVector<TTimeEvent>& timeline, const TVector<TAtomicSharedPtr<TAccountTagHistoryEvent>>& events) override;
    };

public:
    using TCompilationPtr = TAtomicSharedPtr<TCompilation>;
    using TSelector = TDedicatedFleetSessionSelector;

private:
    R_FIELD(TSet<TString>, AcceptableTagIds, {});

protected:
    virtual bool TestEvent(const TAccountTagHistoryEvent& histEvent) const override;

public:
    TDedicatedFleetSession() = default;

    THolder<ICompilation> BuildDefaultCompilation() const override {
        return MakeHolder<TCompilation>();
    }

protected:
    virtual TUniquePtr DoClone() const override {
        return MakeHolder<TDedicatedFleetSession>(*this);
    }
};

class TDedicatedFleetSessionSelector: public ISessionSelector<TTagHistoryEvent> {
private:
    using TBase = ISessionSelector<TTagHistoryEvent>;

public:
    virtual TString GetName() const override {
        return "dedicated_fleet";
    }

    virtual IEventsSession<TTagHistoryEvent>::TPtr BuildSession() const override {
        return new TDedicatedFleetSession();
    }

    virtual NEventsSession::EEventCategory Accept(const TTagHistoryEvent& e) const override;
    static NEventsSession::EEventCategory AcceptImpl(const TCarTagHistoryEvent& event);
};
