#pragma once

#include <drive/backend/data/common/serializable.h>

#include <rtline/util/types/field.h>

class TCarDeliveryTag: public IJsonSerializableTag {
private:
    using TBase = IJsonSerializableTag;

public:
    class TDescription: public TTagDescription {
    public:
        using TTagDescription::TTagDescription;

        virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

    protected:
        virtual NJson::TJsonValue DoSerializeMetaToJson() const override;
        virtual bool DoDeserializeMetaFromJson(const NJson::TJsonValue& value) override;

    private:
        R_FIELD(TVector<TString>, DelivereeTags);

        DECLARE_FIELDS(
            Field(DelivereeTags, "deliveree_tags")
        );
    };

public:
    static TString Type() {
        return "car_delivery_tag";
    }

public:
    using TBase::TBase;

    bool HasLocation() const;

    virtual TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return { NEntityTagsManager::EEntityType::Car };
    }

    virtual EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::Rewrite;
    }

    virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

    virtual bool OnBeforeAdd(const TString& objectId, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) override;
    virtual bool OnBeforeEvolve(const TDBTag& fromTag, ITag::TPtr toTag, const TUserPermissions& permissions, const NDrive::IServer* server, NDrive::TEntitySession& session, const TEvolutionContext* eContext) const override;
    virtual bool OnBeforeRemove(const TDBTag& self, const TString& /*userId*/, const NDrive::IServer* server, NDrive::TEntitySession& session) override;
    virtual bool OnAfterRemove(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const override;

protected:
    virtual bool DoSpecialDataFromJson(const NJson::TJsonValue& value, TMessagesCollector* errors) override;
    virtual void SerializeSpecialDataToJson(NJson::TJsonValue& value) const override;

private:
    R_FIELD(double, Distance, 500);
    R_FIELD(double, Latitude, 0);
    R_FIELD(double, Longitude, 0);

    DECLARE_FIELDS(
        Field(Distance, "distance"),
        Field(Latitude, "latitude"),
        Field(Longitude, "longitude")
    );

private:
    static TFactory::TRegistrator<TCarDeliveryTag> Registrator;
};
