#pragma once

#include <drive/backend/device_snapshot/abstract.h>

#include <util/datetime/base.h>

class TEventsSnapshot : public NDrive::IObjectSnapshot {
public:
    struct TPushInfo {
        TString Content;
        TString Type;
        TInstant Timestamp;
    };
    using TPushInfos = TVector<TPushInfo>;

public:
    TEventsSnapshot() = default;

    static TString Type() {
        return "push";
    }
    virtual TString GetTypeName() const override {
        return Type();
    }

    void AddPush(TPushInfo&& info) {
        PushInfos.push_back(std::move(info));
    }
    const TPushInfos& GetPushes() const {
        return PushInfos;
    }

protected:
    virtual TBlob DoSerializeToBlob() const override;
    virtual bool DoDeserializeFromBlob(const TBlob& data) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonValue) override;

private:
    TPushInfos PushInfos;
};
