#pragma once

#include "delegation.h"

#include <drive/backend/areas/areas.h>
#include <drive/backend/data/common/serializable.h>
#include <drive/backend/chat/message.h>

class TCarDelegationPolicy : public NDrive::ITag::ICustomEvolutionPolicy {
public:
    R_READONLY(ECarDelegationType, Type, ECarDelegationType::Free);
    R_READONLY(TString, UserId);
    R_READONLY(bool, DelegationRequest, false);
    R_READONLY(TString, SessionId);
    R_READONLY(TString, TargetUserId);
    R_READONLY(TString, TagName);

    R_FIELD(TString, FreeDelegationConfirmationLanding);
    R_FIELD(TDuration, P2PDelegationDuration, TDuration::Minutes(3));

public:
    TCarDelegationPolicy(const TString& userId)
        : UserId(userId)
    {
    }

    virtual bool ExecuteAfterEvolveCommit(const TString& objectId, const NDrive::ITag* tag, const TUserPermissions& permissions, const NDrive::IServer* server) const override;
    virtual bool ExecuteBeforeEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override;
    virtual bool ExecuteAfterEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override;

    virtual bool CheckDelegationPossibleFromTag(const TConstDBTag& fromTag, ITag::TAggregateEvolutionPolicy& policyWithError) const;

    bool DeserializeFromJson(const NJson::TJsonValue& json);
    NJson::TJsonValue SerializeToJson() const;

private:
    ITag::TPtr CreateTag(const NDrive::IServer* server) const;
    TString GetConfirmationLandingId(const TConstDBTag& fromTag, const NDrive::IServer* server) const;
    bool NeedToStoreDelegation() const;
};

class TRideFinishPolicy : public NDrive::ITag::ICustomEvolutionPolicy {
private:
    const TCarLocationFeatures CarLocationFeatures;
    const TString TagId;

public:
    TRideFinishPolicy(const TCarLocationFeatures& carLocationFeatures, const TString& tagId)
        : CarLocationFeatures(carLocationFeatures)
        , TagId(tagId)
    {
    }

    virtual bool ExecuteAfterEvolveCommit(const TString& objectId, const NDrive::ITag* tag, const TUserPermissions& permissions, const NDrive::IServer* server) const override;
    virtual bool ExecuteBeforeEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override;
    virtual bool ExecuteAfterEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override;
};

class TAskForSelfiePolicy : public NDrive::ITag::ICustomEvolutionPolicy {
    R_READONLY(TString, VerificationLandingId);

public:
    TAskForSelfiePolicy(const TString& verificationLandingId)
        : VerificationLandingId(verificationLandingId)
    {
    }

    virtual bool ExecuteAfterEvolveCommit(const TString& objectId, const NDrive::ITag* tag, const TUserPermissions& permissions, const NDrive::IServer* server) const override;
    virtual bool ExecuteBeforeEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override;
    virtual bool ExecuteAfterEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override;
};

class TPermitEvolutionPolicy : public NDrive::ITag::ICustomEvolutionPolicy {
public:
    TPermitEvolutionPolicy(const TString& permitTagName, const TString& permitRequiredLandingId)
        : PermitTagName(permitTagName)
        , PermitRequiredLandingId(permitRequiredLandingId)
    {
    }

    virtual bool ExecuteAfterEvolveCommit(const TString& objectId, const NDrive::ITag* tag, const TUserPermissions& permissions, const NDrive::IServer* server) const override final;
    virtual bool ExecuteBeforeEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override final;
    virtual bool ExecuteAfterEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override;

protected:
    const TString PermitTagName;
    const TString PermitRequiredLandingId;
};

class TPassCheckEvolutionPolicy : public NDrive::ITag::ICustomEvolutionPolicy {
public:
    TPassCheckEvolutionPolicy(const TString& passTagName, const TString& passRequiredLandingId, const TString& passChatName, const TString& ignoreTagName)
        : PassTagName(passTagName)
        , PassRequiredLandingId(passRequiredLandingId)
        , PassChatName(passChatName)
        , IgnoreTagName(ignoreTagName)
    {
    }

    virtual bool ExecuteAfterEvolveCommit(const TString& objectId, const NDrive::ITag* tag, const TUserPermissions& permissions, const NDrive::IServer* server) const override final;
    virtual bool ExecuteBeforeEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override final;
    virtual bool ExecuteAfterEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override;

protected:
    const TString PassTagName;
    const TString PassRequiredLandingId;
    const TString PassChatName;
    const TString IgnoreTagName;
};

class TCloseChatEvolutionPolicy : public NDrive::ITag::ICustomEvolutionPolicy {
public:
    TCloseChatEvolutionPolicy(const TVector<TString>& сhatTagNames, const TVector<NDrive::NChat::TMessage>& messages)
        : ChatTagNames(сhatTagNames)
        , Messages(messages)
    {
    }

    virtual bool ExecuteAfterEvolveCommit(const TString& objectId, const NDrive::ITag* tag, const TUserPermissions& permissions, const NDrive::IServer* server) const override;
    virtual bool ExecuteBeforeEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override;
    virtual bool ExecuteAfterEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override;

private:
    const TVector<TString> ChatTagNames;
    TVector<NDrive::NChat::TMessage> Messages;
};

class TScooterFixEvolutionPolicy: public NDrive::ITag::ICustomEvolutionPolicy {
private:
    const TCarLocationFeatures CarLocationFeatures;

public:
    TScooterFixEvolutionPolicy(const TCarLocationFeatures& carLocationFeatures)
        : CarLocationFeatures(carLocationFeatures)
    {
    }

    virtual bool ExecuteAfterEvolveCommit(const TString& objectId, const NDrive::ITag* tag, const TUserPermissions& permissions, const NDrive::IServer* server) const override;
    virtual bool ExecuteBeforeEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override;
    virtual bool ExecuteAfterEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override;
};

class TEmailAfterRideEvolutionPolicy: public NDrive::ITag::ICustomEvolutionPolicy {
public:
    TEmailAfterRideEvolutionPolicy(const TString& emailType)
        : EmailType(emailType)
    {
    }

    virtual bool ExecuteAfterEvolveCommit(const TString& objectId, const NDrive::ITag* tag, const TUserPermissions& permissions, const NDrive::IServer* server) const override;
    virtual bool ExecuteBeforeEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override;
    virtual bool ExecuteAfterEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override;

private:
    R_READONLY(TString, EmailType);
};
