#include "fine.h"

#include <rtline/library/json/parse.h>

const TString TFineActionTag::TypeName = "fine_action_tag";
ITag::TFactory::TRegistrator<TFineActionTag> TFineActionTag::Registrator(TFineActionTag::TypeName);
TFineActionTagDescription::TFactory::TRegistrator<TFineActionTagDescription> TFineActionTagDescription::Registrator(TFineActionTag::TypeName);

NDrive::TScheme TFineActionTagDescription::GetScheme(const NDrive::IServer* server) const {
    NDrive::TScheme result = TBase::GetScheme(server);
    result.Add<TFSVariants>("action_type", "Действие").InitVariants<EFineActionType>();
    return result;
}

NJson::TJsonValue TFineActionTagDescription::DoSerializeMetaToJson() const {
    NJson::TJsonValue jsonMeta = TBase::DoSerializeMetaToJson();
    NJson::InsertField(jsonMeta, "action_type", NJson::Stringify(ActionType));
    return jsonMeta;
}

bool TFineActionTagDescription::DoDeserializeMetaFromJson(const NJson::TJsonValue& jsonMeta) {
    return (NJson::ParseField(jsonMeta["action_type"], NJson::Stringify(ActionType)) &&
            TBase::DoDeserializeMetaFromJson(jsonMeta));
}

EUniquePolicy TFineActionTag::GetUniquePolicy() const {
    return EUniquePolicy::NoUnique;
}

TSet<NEntityTagsManager::EEntityType> TFineActionTag::GetObjectType() const {
    return { NEntityTagsManager::EEntityType::Car, NEntityTagsManager::EEntityType::User };
}

NDrive::TScheme TFineActionTag::GetScheme(const NDrive::IServer* server) const {
    NDrive::TScheme scheme = TBase::GetScheme(server);
    scheme.Add<TFSString>("FineId", "Идентификатор штрафа");
    return scheme;
}

TFineActionTag::TProto TFineActionTag::DoSerializeSpecialDataToProto() const {
    TProto proto = TBase::DoSerializeSpecialDataToProto();
    proto.SetFineId(FineId);
    return proto;
}

bool TFineActionTag::DoDeserializeSpecialDataFromProto(const TProto& proto) {
    FineId = proto.GetFineId();
    return TBase::DoDeserializeSpecialDataFromProto(proto);
}
