#pragma once

#include <drive/backend/data/common/serializable.h>
#include <drive/backend/data/proto/tags.pb.h>

#include <drive/backend/tags/tag_description.h>

#include <rtline/util/types/accessor.h>

enum class EFineActionType : ui32 {
    Undefined = 0 /* "undefined" */,
    Charge = 1 /* "charge" */,
    Update = 2  /* "update" */,
    RequestDecree = 3 /* "request_decree" */,
    RequestViolationDetailedDocument = 4 /* "request_violation_detailed_document" */,
};

class TFineActionTagDescription: public TTagDescription {
    using TBase = TTagDescription;

public:
    virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

protected:
    virtual NJson::TJsonValue DoSerializeMetaToJson() const override;
    virtual bool DoDeserializeMetaFromJson(const NJson::TJsonValue& jsonMeta) override;

private:
    static TFactory::TRegistrator<TFineActionTagDescription> Registrator;

    R_FIELD(EFineActionType, ActionType, EFineActionType::Undefined);
};

class TFineActionTag: public INativeSerializationTag<NDrive::NProto::TFineActionTagData> {
    using TBase = INativeSerializationTag<NDrive::NProto::TFineActionTagData>;

public:
    using TTagDescription = TFineActionTagDescription;

    static const TString TypeName;
    static TFactory::TRegistrator<TFineActionTag> Registrator;

    using TBase::TBase;

    virtual EUniquePolicy GetUniquePolicy() const override;
    virtual TSet<NEntityTagsManager::EEntityType> GetObjectType() const override;

    virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

protected:
    virtual TProto DoSerializeSpecialDataToProto() const override;
    virtual bool DoDeserializeSpecialDataFromProto(const TProto& proto) override;

private:
    R_FIELD(TString, FineId);
};
