#include "images.h"

#include <drive/backend/abstract/frontend.h>
#include <drive/backend/images/database.h>
#include <drive/backend/tags/tags_manager.h>

bool TInvalidateMarkupTag::OnAfterAdd(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const {
    const auto& database = Yensured(server)->GetDriveDatabase();
    const auto& deviceTags = database.GetTagsManager().GetDeviceTags();
    const auto& imageStorage = database.GetImageStorage();

    auto optionalImages = imageStorage.Get(self.GetObjectId(), {}, session);
    if (!optionalImages) {
        return false;
    }
    TImagesStorage::TRecords affectedImages;
    for (auto&& image : *optionalImages) {
        bool changed = false;
        for (auto&& markup : image.MutableMarkUpList()) {
            if (!markup.IsDiscarded()) {
                markup.SetDiscarded(true);
                changed = true;
            }
        }
        if (changed) {
            affectedImages.push_back(std::move(image));
        }
    }

    for (auto&& image : affectedImages) {
        if (!imageStorage.UpdateImage(image, userId, session)) {
            return false;
        }
    }

    return deviceTags.RemoveTag(self, userId, server, session);
}

ITag::TFactory::TRegistrator<TInvalidateMarkupTag> TInvalidateMarkupTag::Registrator(TInvalidateMarkupTag::Type());
